package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.ie.local.entity.ExportField;
import com.biz.crm.common.ie.local.mapper.ExportFieldMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 导出字段（ExportField）表持久层接口
 * @createTime 2023年07月25日 14:41:00
 */
@Component
public class ExportFieldRepository extends ServiceImpl<ExportFieldMapper, ExportField> {


  public List<ExportField> findByMenuCode(String tenantCode, String currentAccount, String menuCode) {
    return this.lambdaQuery()
        .eq(ExportField::getTenantCode,tenantCode)
        .eq(ExportField::getAccount,currentAccount)
        .eq(ExportField::getMenuCode,menuCode)
        .orderByAsc(ExportField::getFormOrder)
        .list();
  }

  public void deleteByMenuCode(String tenantCode, String currentAccount, String menuCode) {
     this.lambdaUpdate()
         .eq(ExportField::getTenantCode,tenantCode)
         .eq(ExportField::getAccount,currentAccount)
         .eq(ExportField::getMenuCode,menuCode)
         .remove();
  }
}
