package com.biz.crm.common.ie.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.model.dto.ImportTaskModelDto;
import com.biz.crm.common.ie.local.model.vo.ImportTaskUpdateModelVo;
import com.biz.crm.common.ie.local.service.internal.ImportTaskThreadLocalServImpl;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 导入任务信息(ImportTask)表服务接口
 *
 * @author sunx
 * @date 2022-05-12 09:25:18
 */
public interface ImportTaskService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<ImportTask> findByConditions(Pageable pageable, ImportTaskPaginationDto dto);

  /**
   * 按taskCode查询详情
   *
   * @param taskCode 任务编码
   * @return
   */
  ImportTask findDetailByTaskCode(String taskCode);

  /**
   * 创建
   *
   * @param importTask 导出任务
   * @return
   */
  ImportTask create(ImportTask importTask);

  /**
   * 根据ImportTaskModelDto获取任务信息
   *
   * @param dto 导出任务
   * @return
   */
  List<ImportTask> findByImportTaskModelDto(ImportTaskModelDto dto);

  /**
   * 更新导入执行任务
   *
   * @param vo 导入任务更新信息
   * @deprecated
   * @see ImportTaskThreadLocalServImpl#updateByImportTaskUpdateModelVo(ImportTaskUpdateModelVo)
   */
  void updateByImportTaskUpdateModelVo(ImportTaskUpdateModelVo vo);

  /**
   * 更新任务加载状态
   *
   * @param taskCodes 任务编码
   * @param loadStatus 加载状态
   */
  void updateLocalStatus(Set<String> taskCodes, String loadStatus);
}
