package com.biz.crm.common.ie.local.service.spring.rest.strategy;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseFactory
 * @date 2023/10/9 13:56
 * @author Kevin
 * @description 参数转换工厂
 */
@Slf4j
@Component
public class ParamsParseFactory {

  @Autowired
  private List<IRequestParamParse<?>> iRequestParamParseList;

  public  Object resolveArgument(final Class<?> parameterType,final String defaultValue){
    Object resolveArgument = null;
    boolean haveParse = false;
    for (IRequestParamParse<?> iRequestParamParse : iRequestParamParseList){
      if (iRequestParamParse.isApplicable(parameterType)){
        haveParse = true;
        try{
          resolveArgument = iRequestParamParse.getValue(defaultValue);
        }catch (IllegalArgumentException e){
          log.error("使用注解RequestParam设置默认值[{}]无法使用策略类转换:{}",defaultValue,iRequestParamParse.getClass());
          throw e;
        }
        break;
      }
    }
    if (Boolean.FALSE.equals(haveParse)){
      log.error("{}没有适配解析器实现类[IRequestParamParse]",parameterType);
      throw  new  IllegalArgumentException(parameterType + "没有适配解析器实现类[IRequestParamParse]");
    }
    return resolveArgument;
  }


}
