package com.biz.crm.common.ie.local.service.strategy;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.biz.crm.common.ie.sdk.vo.ExcelItemVo;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

/**
 * 导出任务合并文件监听实现
 *
 * @author sunx
 * @date 2022/6/8
 */
public class CrmExportExcelReadListener extends AnalysisEventListener<Map<Integer, Object>> {
  private Integer batchCount;
  private ExcelWriter excelWriter;
  private WriteSheet writeSheet;

  private List<List<Object>> cachedDataList = Lists.newLinkedList();
  private Integer cacheCursor = 0;

  public CrmExportExcelReadListener(
      Integer batchCount, ExcelWriter excelWriter, WriteSheet writeSheet) {
    this.batchCount = batchCount;
    this.excelWriter = excelWriter;
    this.writeSheet = writeSheet;
  }

  @Override
  public void invoke(Map<Integer, Object> data, AnalysisContext context) {
    if (this.cacheCursor.equals(batchCount)) {
      this.execute();
    }
    List<Object> cur = this.findData(data);
    cachedDataList.add(cur);
    cacheCursor++;
  }

  @Override
  public void doAfterAllAnalysed(AnalysisContext context) {
    this.execute();
  }

  /** 业务处理 */
  private void execute() {
    if (cachedDataList == null || cachedDataList.isEmpty()) {
      return;
    }
    this.excelWriter.write(cachedDataList, writeSheet);
    this.resetCache();
  }

  /**
   * 根据解析的行记录获取业务处理对象数据
   *
   * @param data
   * @return
   */
  private List<Object> findData(Map<Integer, Object> data) {
    if (data == null || data.isEmpty()) {
      return Lists.newLinkedList();
    }
    List<ExcelItemVo> items = Lists.newLinkedList();
    for (Entry<Integer, Object> item : data.entrySet()) {
      final ExcelItemVo cur = new ExcelItemVo();
      cur.setColumn(item.getKey());
      cur.setData(item.getValue());
      items.add(cur);
    }
    return items.stream()
        .sorted(Comparator.comparing(ExcelItemVo::getColumn))
        .map(ExcelItemVo::getData)
        .collect(Collectors.toList());
  }

  /** 重置缓存 */
  private void resetCache() {
    this.cacheCursor = 0;
    this.cachedDataList = Lists.newLinkedList();
  }
}
