/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.thread.ThreadUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.service.ImportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_IeTaskExecutorForImport")
@Scope(value="prototype")
@Lazy
public class IeTaskExecutorForImport
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IeTaskExecutorForImport.class);
    private IeExecutorVoForImport vo;
    private AbstractTenantInfo tenantInfo;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private ImportProcessService importProcessService;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public IeTaskExecutorForImport(IeExecutorVoForImport importExportExecutorVo, AbstractTenantInfo tenantInfo) {
        this.vo = importExportExecutorVo;
        this.tenantInfo = tenantInfo;
    }

    @Override
    public void run() {
        TenantContextHolder.setTenantInfo((AbstractTenantInfo)this.tenantInfo);
        String appCode = TenantUtils.getAppCode();
        log.debug("******\u5bfc\u5165\u4efb\u52a1\u5f00\u59cb\u6267\u884c\u4e2d*********{}", (Object)appCode);
        Integer defaultLoginType = this.simpleSecurityProperties.getDefaultLoginType();
        try {
            TaskExecutorAuthTool.refreshUseAuthAndTenantCode(this.loginUserService, (IeExecutorVo)this.vo, defaultLoginType);
            this.importProcessService.importProcess((IeExecutorVo)this.vo);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.debug("******\u5bfc\u5165\u4efb\u52a1\u5f00\u59cb\u6267\u5b8c\u6210*********");
        long taskExecutionAfterSleep = this.importExportProperties.getTaskExecutionIntervalSleep();
        if (taskExecutionAfterSleep > 0L) {
            ThreadUtil.sleep((long)taskExecutionAfterSleep);
            log.debug("******\u4f11\u7720\u91ca\u653e\u6570\u636e\u5e93\u538b\u529b*********");
        }
    }

    public AbstractTenantInfo getTenantInfo() {
        return this.tenantInfo;
    }
}

