/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.mapper.ExportTaskMapper;
import com.biz.crm.common.ie.local.model.dto.ExportTaskConditionModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskProcessModelDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.CallbackStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.configuration.MultiDataSourceProperties;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportTaskRepository
extends ServiceImpl<ExportTaskMapper, ExportTask> {
    @Autowired
    private MultiDataSourceProperties multiDataSourceProperties;

    public Page<ExportTask> findByConditions(Page<ExportTask> page, ExportTaskPaginationDto dto) {
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            dto.setAppCode(TenantUtils.getAppCode());
        }
        return ((ExportTaskMapper)this.baseMapper).findByConditions(page, dto);
    }

    public ExportTask findByTaskCode(String taskCode) {
        LambdaQueryChainWrapper lambdaQuery = this.lambdaQuery();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaQuery.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        return (ExportTask)((Object)((LambdaQueryChainWrapper)lambdaQuery.eq(ExportTask::getTaskCode, (Object)taskCode)).one());
    }

    public List<ExportTask> findByIds(List<String> ids) {
        LambdaQueryChainWrapper lambdaQuery = this.lambdaQuery();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaQuery.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        return ((LambdaQueryChainWrapper)lambdaQuery.in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateExecStatusByTaskCodes(ExecStatusEnum execStatusEnum, Set<String> taskCodes) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(ExportTask::getTaskCode, taskCodes)).set(ExportTask::getExecStatus, (Object)execStatusEnum.getDictCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateCallBackStatusByIds(List<String> ids, CallbackStatusEnum callbackStatusEnum) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ExportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(UuidEntity::getId, ids)).set(ExportTask::getCallBackStatus, (Object)callbackStatusEnum.getDictCode())).update();
    }

    public void updateByExportTaskProcessModelDto(ExportTaskProcessModelDto dto) {
        if (dto == null || StringUtils.isBlank((CharSequence)dto.getTaskCode())) {
            return;
        }
        ExportTask exportTask = this.findByTaskCode(dto.getTaskCode());
        exportTask.setExecStatus(dto.getExecStatus());
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark())) {
            exportTask.setRemark(dto.getRemark());
        }
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            exportTask.setAppCode(TenantUtils.getAppCode());
        }
        this.updateById((Object)exportTask);
    }

    public int getTaskCountByNoExe(ExportTask current) {
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            current.setAppCode(TenantUtils.getAppCode());
        }
        Date createTime = current.getCreateTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createTime);
        calendar.add(5, -1);
        Date createTimeForBegin = calendar.getTime();
        int taskCountByNoExe = ((ExportTaskMapper)this.getBaseMapper()).getTaskCountByNoExe(current, createTimeForBegin);
        return taskCountByNoExe;
    }

    public List<ExportTask> findExportTaskNoGetTotal(ExportTaskModelDto dto) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date createTimeForBegin = calendar.getTime();
        return ((ExportTaskMapper)this.getBaseMapper()).findExportTaskNoGetTotal(dto, createTimeForBegin);
    }

    public List<ExportTask> findByExportTaskConditionModelDto(ExportTaskConditionModelDto dto) {
        return ((ExportTaskMapper)this.getBaseMapper()).findByExportTaskConditionModelDto(dto);
    }
}

