/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.entity.ExportTaskRelateFile;
import com.biz.crm.common.ie.local.model.dto.ExportTaskConditionModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskProcessModelDto;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskDetailRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRelateFileRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.sdk.dto.CreateExportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.event.ImportExportTaskEventListener;
import com.biz.crm.common.ie.sdk.excel.process.AbstractEsParagraphExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.EsParagraphFieldRangeVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Service(value="exportTaskService")
public class ExportTaskServiceImpl
implements ExportTaskService {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskServiceImpl.class);
    @Autowired(required=false)
    private ExportTaskRepository exportTaskRepository;
    @Autowired(required=false)
    private ExportTaskRelateFileRepository exportTaskRelateFileRepository;
    @Autowired(required=false)
    private ExportTaskDetailService exportTaskDetailService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ExportTaskDetailRepository exportTaskDetailRepository;
    @Autowired(required=false)
    private ExportSendProcessMsgBean exportSendProcessMsgBean;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ImportExportTaskEventListener> importExportTaskAuthRecordListeners;
    private static final String EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";
    @Autowired
    private ExportProcessService exportProcessService;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private ElasticsearchQueryService elasticsearchQueryService;

    @Override
    public Page<ExportTask> findByConditions(Pageable pageable, ExportTaskPaginationDto dto) {
        Set<String> taskCodeSet;
        List<ExportTaskDetail> list;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ExportTaskPaginationDto());
        dto.setApplicationName(this.importExportProperties.getIeTaskGroup());
        dto.setAppCode(TenantUtils.getTenantCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ExportTask> result = this.exportTaskRepository.findByConditions((Page<ExportTask>)page, dto);
        if (Objects.nonNull(result) && !CollectionUtils.isEmpty((Collection)result.getRecords()) && !CollectionUtils.isEmpty(list = this.exportTaskDetailService.findByTaskCodes(taskCodeSet = result.getRecords().stream().map(ExportTask::getTaskCode).collect(Collectors.toSet())))) {
            Map<String, List<ExportTaskDetail>> map = list.stream().collect(Collectors.groupingBy(ExportTaskDetail::getTaskCode));
            for (ExportTask item : result.getRecords()) {
                item.setList(map.get(item.getTaskCode()));
            }
        }
        return result;
    }

    @Override
    public void cancelTask(List<String> codes) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty(codes), (String)"\u8bf7\u9009\u62e9\u9884\u53d6\u6d88\u7684\u4efb\u52a1", (Object[])new Object[0]);
        String applicationName = this.importExportProperties.getIeTaskGroup();
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList<String> list = new ArrayList<String>();
        list.add(ExecStatusEnum.DEFAULT.getDictCode());
        list.add(ExecStatusEnum.RUNNING.getDictCode());
        codes.forEach(k -> {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.exportTaskRepository.lambdaUpdate().set(ExportTask::getExecStatus, (Object)ExecStatusEnum.CANCEL.getDictCode())).eq(ExportTask::getApplicationName, (Object)applicationName)).eq(ExportTask::getAppCode, (Object)tenantCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ExportTask::getTaskCode, k)).in(ExportTask::getExecStatus, (Collection)list)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.exportTaskDetailRepository.lambdaUpdate().set(ExportTaskDetail::getExecStatus, (Object)ExecStatusEnum.CANCEL.getDictCode())).eq(ExportTaskDetail::getApplicationName, (Object)applicationName)).eq(ExportTaskDetail::getAppCode, (Object)tenantCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ExportTaskDetail::getTaskCode, k)).in(ExportTaskDetail::getExecStatus, (Collection)list)).update();
        });
    }

    @Override
    public ExportTask findDetailByTaskCode(String taskCode) {
        List<ExportTaskRelateFile> fileList;
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        ExportTask exportTask = this.findExportTask(taskCode);
        if (Objects.isNull((Object)exportTask)) {
            return null;
        }
        List<ExportTaskDetail> detailList = this.exportTaskDetailService.findByTaskCodes(Sets.newHashSet((Object[])new String[]{exportTask.getTaskCode()}));
        if (!CollectionUtils.isEmpty(detailList)) {
            for (ExportTaskDetail detail : detailList) {
                OrdinaryFileVo ordinaryFileVo;
                if (!StringUtils.isNotBlank((CharSequence)detail.getFileCode()) || (ordinaryFileVo = this.fileHandleService.findById(detail.getFileCode())) == null) continue;
                FileModelVo fileModelVo = new FileModelVo();
                fileModelVo.setFileCode(ordinaryFileVo.getId());
                fileModelVo.setFileName(ordinaryFileVo.getOriginalFileName());
                detail.setFile(fileModelVo);
            }
        }
        if (!CollectionUtils.isEmpty(fileList = this.exportTaskRelateFileRepository.findByTaskCode(taskCode))) {
            for (ExportTaskRelateFile relateFile : fileList) {
                OrdinaryFileVo ordinaryFileVo;
                if (!StringUtils.isNotBlank((CharSequence)relateFile.getFileCode()) || (ordinaryFileVo = this.fileHandleService.findById(relateFile.getFileCode())) == null) continue;
                FileModelVo fileModelVo = new FileModelVo();
                fileModelVo.setFileCode(ordinaryFileVo.getId());
                fileModelVo.setFileName(ordinaryFileVo.getOriginalFileName());
                relateFile.setFile(fileModelVo);
            }
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            exportTask.setList(detailList);
        }
        if (!CollectionUtils.isEmpty(fileList)) {
            exportTask.setFileList(fileList);
        }
        return exportTask;
    }

    @Override
    public ExportTask findExportTask(String taskCode) {
        return this.exportTaskRepository.findByTaskCode(taskCode);
    }

    @Override
    @Transactional
    public ExportTask create(CreateExportTaskDto dto) {
        this.validateUrlAndParams(dto);
        String businessCode = dto.getBusinessCode();
        ExportProcess exportProcess = this.exportProcessService.findExportProcess(businessCode);
        Validate.notNull((Object)exportProcess, (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5904\u7406\u5668", (Object[])new Object[0]);
        Integer excelMaxCount = this.importExportProperties.getExportProperties().getExcelMaxCount();
        Validate.isTrue((excelMaxCount >= exportProcess.getPageSize() ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u5904\u7406\u5668pageSize\u8bbe\u7f6e\u5fc5\u987b\u5c0f\u4e8e\u5bfc\u51fa\u914d\u7f6e\u7684\u6700\u5927\u5bfc\u51fa\u6570\u91cf\u8bbe\u7f6e", (Object[])new Object[0]);
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        Validate.notNull((Object)dto, (String)"\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ExportTask exportTask = this.convertExportTaskObj(dto);
        this.validation(exportTask, exportProcess);
        this.validateExecutingTask(exportTask);
        if (!exportProcess.isAsyncGetTotal()) {
            exportTask.setCreateAccount(this.loginUserService.findCurrentAccount());
            List<ExportTaskDetail> exportTaskDetail = this.exportTaskDetailService.saveExportTaskAndCreateExportTaskDetail(exportTask);
            log.debug("\u603b\u8bb0\u5f55\u6570{}\uff0c\u62c6\u5206\u4efb\u52a1{}", (Object)exportTask.getTotal(), (Object)exportTaskDetail.size());
        } else {
            this.exportTaskRepository.saveOrUpdate((Object)exportTask);
            log.info("BusinessCode={},\u4efb\u52a1{}\u5f02\u6b65\u83b7\u53d6\u6570\u636e", (Object)dto.getBusinessCode(), (Object)exportTask.getTaskCode());
            String taskCode = exportTask.getTaskCode();
            String createAccount = exportTask.getCreateAccount();
            this.exportSendProcessMsgBean.sendTaskProcessMsg(taskCode, ExecStatusEnum.RUNNING.getDictCode(), ExportProcessEnum.ASYNC_GET_TOTAL, createAccount, (Boolean)true);
        }
        marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        return exportTask;
    }

    private void validateExecutingTask(ExportTask exportTask) {
        ExportTaskConditionModelDto conditionModelDto = new ExportTaskConditionModelDto();
        conditionModelDto.setApplicationName(this.importExportProperties.getIeTaskGroup());
        conditionModelDto.setAppCode(TenantUtils.getTenantCode());
        conditionModelDto.setTenantCode(TenantUtils.getTenantCode());
        conditionModelDto.setBusinessCode(exportTask.getBusinessCode());
        conditionModelDto.setParentCode(exportTask.getParentCode());
        conditionModelDto.setFunctionCode(exportTask.getFunctionCode());
        conditionModelDto.setCreateAccount(this.loginUserService.findCurrentAccount());
        conditionModelDto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.RUNNING.getDictCode(), ExecStatusEnum.DEFAULT.getDictCode(), ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode()}));
        List<ExportTask> exportTasks = this.exportTaskRepository.findByExportTaskConditionModelDto(conditionModelDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(exportTasks), (String)"\u5f53\u524d\u9875\u9762\u6709\u8fdb\u884c\u4e2d\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u8bf7\u5230\u6587\u4ef6\u4e2d\u5fc3\u67e5\u770b\uff01", (Object[])new Object[0]);
    }

    private void validateUrlAndParams(CreateExportTaskDto dto) {
        String businessCode = dto.getBusinessCode();
        if (!"EXPORT_WEB_API".equals(businessCode)) {
            return;
        }
        String url = dto.getWebApiUrl();
        Validate.notNull((Object)url, (String)"webApi\u5bfc\u51fa\u65f6\uff0c\u8bf7\u6c42\u5730\u5740url\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map params = dto.getParams();
        String requestMapping = (String)params.get("requestMapping");
        HandlerMethod handlerMethod = this.getHandlerMethod(url, requestMapping);
        Validate.notNull((Object)handlerMethod, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684url: %s", (Object[])new Object[]{url});
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        int count = 0;
        for (MethodParameter methodParameter : methodParameters) {
            Class parameterType = methodParameter.getParameterType();
            if (parameterType != Pageable.class) continue;
            ++count;
        }
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u63a5\u53e3\u65b9\u6cd5\u5165\u53c2\u672a\u5305\u542bpageable\u5bf9\u8c61\uff01", (Object[])new Object[0]);
        Class<?> returnType = handlerMethod.getMethod().getReturnType();
        Validate.isTrue((returnType == Result.class ? 1 : 0) != 0, (String)"\u63a5\u53e3\u8fd4\u56de\u503c\u7c7b\u578b\u4e0d\u7b26\u5408\u6807\u51c6 :{}", (Object[])new Object[]{returnType});
    }

    private HandlerMethod getHandlerMethod(String url, String requestMapping) {
        String resolveLookUpPath = this.getPath(url);
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        HandlerMethod handlerMethod = null;
        block0: for (Map.Entry handlerMethodEntry : handlerMethods.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)handlerMethodEntry.getKey();
            HandlerMethod tempHandlerMethod = (HandlerMethod)handlerMethodEntry.getValue();
            Set directPaths = requestMappingInfo.getDirectPaths();
            if (!directPaths.contains(resolveLookUpPath)) continue;
            log.info("requestMappingInfo ===>{}", (Object)requestMappingInfo);
            RequestMethodsRequestCondition methodsCondition = requestMappingInfo.getMethodsCondition();
            Set methods = methodsCondition.getMethods();
            for (RequestMethod requestMethod : methods) {
                if (!requestMethod.name().equalsIgnoreCase(requestMapping.toUpperCase())) continue;
                handlerMethod = tempHandlerMethod;
                handlerMethod = handlerMethod.createWithResolvedBean();
                continue block0;
            }
        }
        return handlerMethod;
    }

    private String getPath(String url) {
        String tempUrl = url.toLowerCase().startsWith("http") ? url : (url.startsWith("/") ? "http://127.0.0.1" + url : "http://127.0.0.1/" + url);
        String resolvedLookUpPath = null;
        try {
            URL urlObj = new URL(tempUrl);
            resolvedLookUpPath = urlObj.getPath();
        }
        catch (MalformedURLException e) {
            Validate.isTrue((boolean)false, (String)"URL\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff0c%s", (Object[])new Object[]{url});
        }
        if (resolvedLookUpPath.startsWith(this.contextPath)) {
            resolvedLookUpPath = resolvedLookUpPath.substring(this.contextPath.length());
        }
        return resolvedLookUpPath;
    }

    private ExportTask convertExportTaskObj(CreateExportTaskDto dto) {
        boolean isEuropaForm;
        Map params = dto.getParams();
        if (params != null && !params.isEmpty() && (isEuropaForm = params.containsKey(EUROPA_CODE_PARAMETER_NAME))) {
            dto.setIsEuropa(Boolean.valueOf(isEuropaForm));
            String europaInfoCode = "" + params.get(EUROPA_CODE_PARAMETER_NAME);
            dto.setEuropaInfoCode(europaInfoCode);
        }
        Validate.notBlank((CharSequence)dto.getBusinessCode(), (String)"\u5bfc\u51fa\u4e1a\u52a1\u7f16\u7801\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ExportTask exportTask = new ExportTask();
        exportTask.setBusinessCode(dto.getBusinessCode());
        exportTask.setTaskSource(dto.getTaskSource());
        exportTask.setMarsListCode(StringUtils.isNotBlank((CharSequence)dto.getMarsListCode()) ? dto.getMarsListCode() : null);
        exportTask.setFunctionCode(StringUtils.isNotBlank((CharSequence)dto.getFunctionCode()) ? dto.getFunctionCode() : null);
        exportTask.setParentCode(StringUtils.isNotBlank((CharSequence)dto.getParentCode()) ? dto.getParentCode() : null);
        if (params != null && !params.isEmpty()) {
            String jsonStr = JSONUtil.toJsonStr((Object)params);
            exportTask.setParametersJson(jsonStr);
        }
        String taskCode = this.generateCodeService.generateCodeString("ET");
        exportTask.setTaskCode(taskCode);
        exportTask.setWebApiUrl(dto.getWebApiUrl());
        return exportTask;
    }

    private RequestParameter convertRequestParameter(String europaInfoCode, Map<String, Object> params) {
        DatabaseExecuteExternalRequest requestParameter = new DatabaseExecuteExternalRequest();
        requestParameter.setAttribute(EUROPA_CODE_PARAMETER_NAME, (Object)europaInfoCode);
        requestParameter.setPageable((Pageable)PageRequest.of((int)0, (int)60000));
        params.forEach((key, value) -> requestParameter.setAttribute(key, value));
        String jsonStr = JSONUtil.toJsonStr((Object)requestParameter);
        System.out.println(jsonStr);
        return requestParameter;
    }

    private RequestParameter buildRequestParameter(String jsonParam) {
        DatabaseExecuteExternalRequest invokeParamContent = new DatabaseExecuteExternalRequest();
        if (StringUtils.isNotBlank((CharSequence)jsonParam)) {
            JSONObject bodyJson = JSONObject.parseObject((String)jsonParam);
            Object object = bodyJson.get((Object)"params");
            if (object != null && object instanceof JSONObject) {
                JSONObject params = (JSONObject)object;
                for (Map.Entry entry : params.entrySet()) {
                    if (entry.getValue() instanceof JSON) continue;
                    invokeParamContent.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            Set jsonItems = bodyJson.entrySet();
            for (Map.Entry jsonItem : jsonItems) {
                String key = (String)jsonItem.getKey();
                Object value = jsonItem.getValue();
                if (value instanceof JSON) continue;
                invokeParamContent.setAttribute(key, value);
            }
        }
        invokeParamContent.setPageable((Pageable)PageRequest.of((int)0, (int)60000));
        return invokeParamContent;
    }

    @Override
    public ExportTaskProcessVo findExportTaskModelVoByDetailCode(String detailCode) {
        ExportTaskDetail detail = this.exportTaskDetailService.findByDetailCode(detailCode);
        if (Objects.isNull((Object)detail)) {
            return null;
        }
        ExportTask task = this.exportTaskRepository.findByTaskCode(detail.getTaskCode());
        if (Objects.isNull((Object)task)) {
            return null;
        }
        ExportTaskProcessVo vo = new ExportTaskProcessVo();
        vo.setAppCode(task.getAppCode());
        vo.setApplicationName(task.getApplicationName());
        vo.setBusinessCode(task.getBusinessCode());
        vo.setCreateAccount(task.getCreateAccount());
        vo.setCreateAccountName(task.getCreateName());
        vo.setDetailCode(detail.getDetailCode());
        vo.setExecStatus(detail.getExecStatus());
        vo.setPageNo(detail.getPageNo());
        vo.setTotal(task.getTotal());
        vo.setPageSize(detail.getPageSize());
        vo.setParametersJson(task.getParametersJson());
        vo.setTaskCode(task.getTaskCode());
        vo.setTenantCode(task.getTenantCode());
        vo.setMarsListCode(task.getMarsListCode());
        vo.setFunctionCode(task.getFunctionCode());
        vo.setParentCode(task.getParentCode());
        vo.setWebApiUrl(task.getWebApiUrl());
        if (StringUtils.isNotBlank((CharSequence)detail.getParagraphRanges())) {
            List fieldRanges = JSONArray.parseArray((String)detail.getParagraphRanges(), List.class).stream().map(list -> list.stream().map(object -> (EsParagraphFieldRangeVo)JSON.parseObject((String)JSON.toJSONString((Object)object), EsParagraphFieldRangeVo.class)).collect(Collectors.toList())).collect(Collectors.toList());
            vo.setTotalParagraphFieldRanges(fieldRanges);
        }
        return vo;
    }

    @Override
    @Transactional
    public void updateExecStatus(ExportTaskProcessModelDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d8\u66f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskCode(), dto.getExecStatus()}), (String)"\u4efb\u52a1\u7f16\u7801\u3001\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.exportTaskRepository.updateByExportTaskProcessModelDto(dto);
    }

    @Override
    @Transactional
    public void updateByExportTaskProcessModelDto(ExportTaskProcessModelDto dto) {
        this.updateExecStatus(dto);
        this.exportTaskRelateFileRepository.deleteByTaskCode(dto.getTaskCode());
        Date now = new Date();
        if (!CollectionUtils.isEmpty(dto.getFileCodeSet())) {
            int i = 0;
            ArrayList list = Lists.newArrayList();
            for (String item : dto.getFileCodeSet()) {
                ExportTaskRelateFile cur = new ExportTaskRelateFile();
                cur.setFileCode(item);
                cur.setSort(i++);
                cur.setTaskCode(dto.getTaskCode());
                cur.setCreateTime(now);
                list.add(cur);
            }
            this.exportTaskRelateFileRepository.saveBatch(list);
        }
    }

    private List<ExportTaskDetail> findDetail(ExportTask exportTask, Integer total, Integer pageSize) {
        Validate.isTrue((pageSize.compareTo(0) > 0 ? 1 : 0) != 0, (String)"\u5904\u7406\u5668\u5b50\u4efb\u52a1\u62c6\u5206size\u9700\u5927\u4e8e0", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayList();
        Integer page = total % pageSize == 0 ? total / pageSize - 1 : total / pageSize;
        Integer lastPageSize = total % pageSize == 0 ? pageSize : total % pageSize;
        for (int i = 0; i <= page; ++i) {
            ExportTaskDetail cur = new ExportTaskDetail();
            cur.setPageSize(i == page ? lastPageSize : pageSize);
            cur.setPageNo(i);
            cur.setTaskCode(exportTask.getTaskCode());
            cur.setAppCode(exportTask.getAppCode());
            cur.setApplicationName(exportTask.getApplicationName());
            cur.setDetailCode(exportTask.getTaskCode() + "_" + cur.getPageNo());
            cur.setMarsListCode(exportTask.getMarsListCode());
            list.add(cur);
        }
        return list;
    }

    private Map<String, Object> findParams(ExportProcess exportProcess, CreateExportTaskDto dto) {
        if (Objects.isNull(exportProcess)) {
            return Maps.newHashMap();
        }
        Map map = exportProcess.getGlobalParams();
        if (map == null) {
            map = Maps.newHashMap();
        }
        if (dto.getParams() != null && !dto.getParams().isEmpty()) {
            for (Map.Entry item : dto.getParams().entrySet()) {
                map.put(item.getKey(), item.getValue());
            }
        }
        return map;
    }

    private void validation(ExportTask exportTask, ExportProcess<?> exportProcess) {
        Validate.notNull((Object)((Object)exportTask), (String)"\u5bfc\u51fa\u4efb\u52a1\u521b\u5efa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)exportTask.getBusinessCode(), (String)"\u5bfc\u51fa\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        exportTask.setTaskName(exportProcess.getBusinessName());
        exportTask.setExecStatus(exportProcess.isAsyncGetTotal() ? ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode() : ExecStatusEnum.DEFAULT.getDictCode());
        exportTask.setTenantCode(TenantUtils.getTenantCode());
        exportTask.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        exportTask.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        exportTask.setApplicationName(this.importExportProperties.getIeTaskGroup());
        exportTask.setAppCode(TenantUtils.getTenantCode());
        exportTask.setAsyncGetTotal(exportProcess.isAsyncGetTotal());
        ExportTaskProcessVo task = (ExportTaskProcessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)exportTask, ExportTaskProcessVo.class, HashSet.class, ArrayList.class, new String[0]);
        String fileName = null;
        String fileTempName = exportProcess.getTaskFileName(task);
        fileName = StringUtils.isNotBlank((CharSequence)fileTempName) ? CharSequenceUtil.format((CharSequence)"{}_{}{}", (Object[])new Object[]{fileTempName, 0, ".xlsx"}) : CharSequenceUtil.format((CharSequence)"\u4e3b\u6587\u4ef6_{}_{}_{}{}", (Object[])new Object[]{task.getTaskSource(), exportTask.getTaskCode(), 0, ".xlsx"});
        exportTask.setFileName(fileName);
    }

    @Override
    public int getTaskCountByNoExe(ExportTask current) {
        return this.exportTaskRepository.getTaskCountByNoExe(current);
    }

    @Override
    public void updateExecStatus(String applicationName, ExecStatusEnum running, String ... taskIdArray) {
        ArrayList<ExportTask> entityList = new ArrayList<ExportTask>();
        for (String id : taskIdArray) {
            ExportTask exportTask = new ExportTask();
            exportTask.setId(id);
            exportTask.setExecStatus(running.getDictCode());
            entityList.add(exportTask);
        }
        this.exportTaskRepository.saveOrUpdateBatch(entityList);
    }

    @Override
    @Transactional
    public void updateExecStatusContainsDetail(ExecStatusEnum execStatusEnum, Set<String> taskCodes) {
        this.exportTaskRepository.updateExecStatusByTaskCodes(execStatusEnum, taskCodes);
        this.exportTaskDetailRepository.updateExecStatusByTaskCodes(execStatusEnum, taskCodes);
    }

    @Override
    public List<ExportTask> findExportTaskNoGetTotal(ExportTaskModelDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        log.debug("\u8bfb\u53d6\u4e00\u5929\u5185\u7684\u6ca1\u6709\u83b7\u53d6\u603b\u6570\u7684\u4efb\u52a1");
        return this.exportTaskRepository.findExportTaskNoGetTotal(dto);
    }

    @Override
    public List<ExportTask> findExportTaskNoEsParagraph(ExportTaskModelDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        ExportTaskConditionModelDto modelDto = new ExportTaskConditionModelDto();
        modelDto.setExecStatusSet(dto.getExecStatusSet());
        modelDto.setApplicationName(dto.getApplicationName());
        return this.exportTaskRepository.findByExportTaskConditionModelDto(modelDto);
    }

    @Override
    @Transactional
    public void execExportGetTotal(ExportTask exportTask) {
        List<ExportTaskDetail> exportTaskDetails = this.exportTaskDetailService.saveExportTaskAndCreateExportTaskDetail(exportTask);
        ExportProcess exportProcess = this.exportProcessService.findExportProcess(exportTask.getBusinessCode());
        exportTask.setList(exportTaskDetails);
        ExecStatusEnum execStatus = ExecStatusEnum.DEFAULT;
        if (exportProcess instanceof AbstractEsParagraphExportProcess) {
            execStatus = ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL;
        }
        this.updateExecStatus(exportTask.getApplicationName(), execStatus, exportTask.getId());
    }

    @Override
    public void execExportEsParagraph(ExportTask exportTask) {
        this.exportSendProcessMsgBean.sendTaskProcessMsg(exportTask.getTaskCode(), ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode(), ExportProcessEnum.ASYNC_ES_PARAGRAPH, exportTask.getCreateAccount(), (Boolean)true);
        List<ExportTaskDetail> taskDetails = this.exportTaskDetailService.findByTaskCodes(Sets.newHashSet((Object[])new String[]{exportTask.getTaskCode()}));
        taskDetails.sort(Comparator.comparing(ExportTaskDetail::getPageNo));
        List<Object> lastFieldRanges = Lists.newArrayList();
        for (ExportTaskDetail exportTaskDetail : taskDetails) {
            lastFieldRanges = this.exportTaskDetailService.execExportTaskDetailEsParagraph(exportTask, exportTaskDetail, lastFieldRanges);
        }
        this.updateExecStatus(exportTask.getApplicationName(), ExecStatusEnum.DEFAULT, exportTask.getId());
    }
}

