/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.thread.ThreadUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.local.service.task.cache.ExportTaskCache;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExportEsParagraph;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_IeTaskExecutorForExportEsParagraph")
@Scope(value="prototype")
@Lazy
public class IeTaskExecutorForExportEsParagraph
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IeTaskExecutorForExportEsParagraph.class);
    private IeExecutorVoForExportEsParagraph vo;
    private ExportTask exportTask;
    private AbstractTenantInfo tenantInfo;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ExportTaskService exportTaskService;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private ExportTaskCache exportTaskCache;

    public IeTaskExecutorForExportEsParagraph(IeExecutorVoForExportEsParagraph vo, ExportTask exportTask, AbstractTenantInfo tenantInfo) {
        this.vo = vo;
        this.exportTask = exportTask;
        this.tenantInfo = tenantInfo;
    }

    @Override
    public void run() {
        TenantContextHolder.setTenantInfo((AbstractTenantInfo)this.tenantInfo);
        Integer defaultLoginType = this.simpleSecurityProperties.getDefaultLoginType();
        try {
            TaskExecutorAuthTool.refreshUseAuthAndTenantCode(this.loginUserService, (IeExecutorVo)this.vo, defaultLoginType);
            this.exportTaskService.execExportEsParagraph(this.exportTask);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
            this.exportTaskService.updateExecStatusContainsDetail(ExecStatusEnum.FAILED, Sets.newHashSet((Object[])new String[]{this.exportTask.getTaskCode()}));
        }
        finally {
            this.exportTaskCache.removeExecEsParagraphTask(this.exportTask.getAppCode(), this.exportTask.getApplicationName(), this.exportTask.getTaskCode());
        }
        log.debug("******\u5bfc\u51fa\u4efb\u52a1\u5206\u6bb5\u5b50\u4efb\u52a1\u6570\u636e\u5b8c\u6210*********");
        long taskExecutionAfterSleep = this.importExportProperties.getTaskExecutionIntervalSleep();
        if (taskExecutionAfterSleep > 0L) {
            ThreadUtil.sleep((long)taskExecutionAfterSleep);
            log.debug("******\u4f11\u7720\u91ca\u653e\u6570\u636e\u5e93\u65f6\u95f4\u5206\u7247*********");
        }
    }

    public IeExecutorVoForExportEsParagraph getVo() {
        return this.vo;
    }
}

