/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.strategy;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.biz.crm.common.ie.sdk.vo.ExcelItemVo;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CrmExportExcelReadListener
extends AnalysisEventListener<Map<Integer, Object>> {
    private Integer batchCount;
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private List<List<Object>> cachedDataList = Lists.newLinkedList();
    private Integer cacheCursor = 0;

    public CrmExportExcelReadListener(Integer batchCount, ExcelWriter excelWriter, WriteSheet writeSheet) {
        this.batchCount = batchCount;
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
    }

    public void invoke(Map<Integer, Object> data, AnalysisContext context) {
        if (this.cacheCursor.equals(this.batchCount)) {
            this.execute();
        }
        List<Object> cur = this.findData(data);
        this.cachedDataList.add(cur);
        Integer n = this.cacheCursor;
        Integer n2 = this.cacheCursor = Integer.valueOf(this.cacheCursor + 1);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.execute();
    }

    private void execute() {
        if (this.cachedDataList == null || this.cachedDataList.isEmpty()) {
            return;
        }
        this.excelWriter.write(this.cachedDataList, this.writeSheet);
        this.resetCache();
    }

    private List<Object> findData(Map<Integer, Object> data) {
        if (data == null || data.isEmpty()) {
            return Lists.newLinkedList();
        }
        LinkedList items = Lists.newLinkedList();
        for (Map.Entry<Integer, Object> item : data.entrySet()) {
            ExcelItemVo cur = new ExcelItemVo();
            cur.setColumn(item.getKey());
            cur.setData(item.getValue());
            items.add(cur);
        }
        return items.stream().sorted(Comparator.comparing(ExcelItemVo::getColumn)).map(ExcelItemVo::getData).collect(Collectors.toList());
    }

    private void resetCache() {
        this.cacheCursor = 0;
        this.cachedDataList = Lists.newLinkedList();
    }
}

