package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导出任务子任务(ExportTaskDetail)实体类
 *
 * @author sunx
 * @since 2022-05-18 16:31:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_export_task_detail")
@Table(
    name = "ie_export_task_detail",
    indexes = {
      @Index(name = "ie_e_t_d_idx1", columnList = "detail_code", unique = true),
      @Index(name = "ie_e_t_d_idx3_atple", columnList = "application_name,task_code,page_no,load_status,exec_status"),
    })
@ApiModel(value = "ExportTaskDetail", description = "导出任务子任务")
@org.hibernate.annotations.Table(appliesTo = "ie_export_task_detail", comment = "导出任务子任务")
public class ExportTaskDetail extends TenantOpEntity {
  private static final long serialVersionUID = 1026015665446737724L;

  /** 主任务编码 */
  @ApiModelProperty("主任务编码")
  @TableField(value = "task_code")
  @Column(name = "task_code", length = 64, columnDefinition = "varchar(64) COMMENT '主任务编码'")
  private String taskCode;

  /** 子任务编码 */
  @ApiModelProperty("子任务编码")
  @TableField(value = "detail_code")
  @Column(name = "detail_code", length = 64, columnDefinition = "varchar(64) COMMENT '子任务编码'")
  private String detailCode;

  /** 页码 */
  @ApiModelProperty("页码")
  @TableField(value = "page_no")
  @Column(name = "page_no", length = 11, columnDefinition = "int(11) COMMENT '页码'")
  private Integer pageNo;

  /** 子任务pageSize */
  @ApiModelProperty("子任务pageSize")
  @TableField(value = "page_size")
  @Column(name = "page_size", length = 11, columnDefinition = "int(11) COMMENT '子任务pageSize'")
  private Integer pageSize;

  /** 子任务执行状态 */
  @ApiModelProperty("子任务执行状态")
  @TableField(value = "exec_status")
  @Column(name = "exec_status", length = 64, columnDefinition = "varchar(64) COMMENT '子任务执行状态'")
  private String execStatus;

  /** 任务加载状态 */
  @ApiModelProperty("任务加载状态")
  @TableField(value = "load_status")
  @Column(name = "load_status", length = 64, columnDefinition = "varchar(64) COMMENT '任务加载状态'")
  private String loadStatus;

  /** 应用名称 */
  @ApiModelProperty("应用名称")
  @TableField(value = "application_name")
  @Column(name = "application_name", length = 64, columnDefinition = "varchar(64) COMMENT '应用名称'")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  @TableField(value = "app_code")
  @Column(name = "app_code", length = 64, columnDefinition = "varchar(64) COMMENT '顶级租户编码'")
  private String appCode;
  
  /**
   * 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE
   */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  @TableField(value = "mars_list_code")
  @Column(name = "mars_list_code" , nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '数据权限控制所需要的，由head信息携带的MARS_LIST_CODE'")
  private String marsListCode;

  /** 文件编码 */
  @ApiModelProperty("文件编码")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 255, columnDefinition = "varchar(255) COMMENT '文件编码'")
  private String fileCode;

  /** 备注 */
  @ApiModelProperty("备注")
  @TableField(value = "remark")
  @Column(name = "remark", length = 255, columnDefinition = "varchar(255) COMMENT '备注'")
  private String remark;

  /** 是否是主任务 */
  @ApiModelProperty("是否是主任务")
  @Transient
  @TableField(exist = false)
  private Boolean mainFlag = false;

  /** 文件信息 */
  @ApiModelProperty("文件信息")
  @Transient
  @TableField(exist = false)
  private FileModelVo file;

  /** 执行时长 */
  @ApiModelProperty("执行时长")
  @TableField(value = "execute_duration")
  @Column(name = "execute_duration", length = 11, columnDefinition = "int(11) COMMENT '执行时长'")
  private Integer executeDuration;

  /** ES导出分段信息 */
  @ApiModelProperty("ES导出分段信息")
  @TableField(value = "paragraph_ranges")
  @Column(name = "paragraph_ranges", columnDefinition = "TEXT COMMENT 'ES导出分段信息'")
  private String paragraphRanges;
}
