package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导入任务信息(ImportTask)实体类
 *
 * @author sunx
 * @since 2022-05-12 09:25:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_import_task")
@Table(
    name = "ie_import_task",
    indexes = {
      @Index(name = "ie_i_task_idx1", columnList = "application_name,template_code,app_code"),
      @Index(name = "ie_i_task_idx2", columnList = "exec_status,load_status"),
      @Index(name = "ie_i_task_idx3", columnList = "tenant_code"),
      @Index(name = "ie_i_task_idx4", columnList = "task_code", unique = true),
      @Index(name = "ie_i_task_idx5", columnList = "create_time"),
    })
@ApiModel(value = "ImportTask", description = "导入任务信息")
@org.hibernate.annotations.Table(appliesTo = "ie_import_task", comment = "导入任务信息")
public class ImportTask extends TenantFlagOpEntity {
  private static final long serialVersionUID = -7008788886761128493L;

  /** 导入任务编码 */
  @ApiModelProperty("导入任务编码")
  @TableField(value = "task_code")
  @Column(name = "task_code", length = 64, columnDefinition = "varchar(64) COMMENT '导入任务编码'")
  private String taskCode;

  /** 任务名称 */
  @ApiModelProperty("任务名称")
  @TableField(value = "task_name")
  @Column(name = "task_name", length = 64, columnDefinition = "varchar(64) COMMENT '任务名称'")
  private String taskName;

  /** 业务编码 */
  @ApiModelProperty("业务编码")
  @TableField(value = "business_code")
  @Column(name = "business_code", length = 64, columnDefinition = "varchar(64) COMMENT '业务编码'")
  private String businessCode;

  /** 文件来源 */
  @ApiModelProperty("文件来源")
  @TableField(value = "task_source")
  @Column(name = "task_source", length = 255, columnDefinition = "varchar(255) COMMENT '文件来源'")
  private String taskSource;

  /** 业务名称 */
  @ApiModelProperty("业务名称")
  @TableField(exist = false)
  @Transient
  private String businessName;

  /** 模板编码 */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", length = 64, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /** 模板名称 */
  @ApiModelProperty("模板名称")
  @TableField(exist = false)
  @Transient
  private String templateName;

  /** 上传文件编码 */
  @ApiModelProperty("上传文件编码")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 255, columnDefinition = "varchar(255) COMMENT '上传文件编码'")
  private String fileCode;

  /** 上传处理参数 */
  @ApiModelProperty("上传处理参数")
  @TableField(value = "parameters_json")
  @Column(
      name = "parameters_json",
      length = 800,
      columnDefinition = "varchar(800) COMMENT '上传处理参数'")
  private String parametersJson;

  /**
   * 任务执行状态
   *
   * @see ExecStatusEnum
   */
  @ApiModelProperty("任务执行状态")
  @TableField(value = "exec_status")
  @Column(name = "exec_status", length = 64, columnDefinition = "varchar(64) COMMENT '任务执行状态'")
  private String execStatus;

  /**
   * 数据导入状态
   *
   * @see ImportDataStatusEnum
   */
  @ApiModelProperty("导入数据行状态")
  @TableField(value = "import_data_status")
  @Column(name = "import_data_status", length = 20, columnDefinition = "varchar(20) COMMENT '导入数据行状态'")
  private String importDataStatus;

  /**
   * 任务加载状态
   *
   * @see LoadStatusEnum
   */
  @ApiModelProperty("任务加载状态")
  @TableField(value = "load_status")
  @Column(name = "load_status", length = 64, columnDefinition = "varchar(64) COMMENT '任务加载状态'")
  private String loadStatus;

  /** 总数 */
  @ApiModelProperty("总数")
  @TableField(value = "total")
  @Column(name = "total", length = 11, columnDefinition = "int(11) COMMENT '总数'")
  private Integer total;

  /** 失败记录数 */
  @ApiModelProperty("失败记录数")
  @TableField(value = "failed_num")
  @Column(name = "failed_num", length = 11, columnDefinition = "int(11) COMMENT '失败记录数'")
  private Integer failedNum;

  /** 失败文件编码 */
  @ApiModelProperty("失败文件编码")
  @TableField(value = "failed_file_code")
  @Column(
      name = "failed_file_code",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '失败文件编码'")
  private String failedFileCode;

  /** 应用 */
  @ApiModelProperty("应用")
  @TableField(value = "application_name")
  @Column(name = "application_name", length = 64, columnDefinition = "varchar(64) COMMENT '应用'")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  @TableField(value = "app_code")
  @Column(name = "app_code", length = 64, columnDefinition = "varchar(64) COMMENT '顶级租户编码'")
  private String appCode;

  /** 回调状态-执行成功或者失败回调状态 */
  @ApiModelProperty("回调状态-执行成功或者失败回调状态")
  @TableField(value = "call_back_status")
  @Column(name = "call_back_status", length = 32, columnDefinition = "varchar(32) COMMENT '回调状态-执行成功或者失败回调状态'")
  private String callBackStatus;

  /** 原文件 */
  @ApiModelProperty("原文件")
  @Transient
  @TableField(exist = false)
  private FileModelVo file;

  /** 错误文件 */
  @ApiModelProperty("错误文件")
  @Transient
  @TableField(exist = false)
  private FileModelVo failedFile;
}
