/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.biz.crm.common.ie.local.service.ImportExportTaskPoolService;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForExport;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForImport;
import com.biz.crm.common.ie.local.service.task.ImportExportThreadPoolExecutor;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ImportExportTaskPoolServiceImpl
implements ImportExportTaskPoolService {
    private static final Logger log = LoggerFactory.getLogger(ImportExportTaskPoolServiceImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="_importExportThreadPoolExecutor")
    private ImportExportThreadPoolExecutor importExportThreadPoolExecutor;

    @Override
    public void reloadTask(String poolName, String taskCode, String ieType, String applicationName) {
        AbstractExecutorService executor = null;
        Runnable run = null;
        if (TypeEnum.IMPORT.getDictCode().equals(ieType)) {
            IeExecutorVoForImport vo = new IeExecutorVoForImport();
            vo.setTaskCode(taskCode);
            vo.setApplicationName(applicationName);
            run = (Runnable)this.applicationContext.getBean(IeTaskExecutorForImport.class, new Object[]{vo});
            executor = this.importExportThreadPoolExecutor.findImportThreadPoolExecutorByKey(poolName);
        } else if (TypeEnum.EXPORT.getDictCode().equals(ieType)) {
            IeExecutorVoForExport vo = new IeExecutorVoForExport();
            vo.setTaskCode(taskCode);
            vo.setApplicationName(applicationName);
            vo.setExportTaskDetailCode(taskCode);
            run = (Runnable)this.applicationContext.getBean(IeTaskExecutorForExport.class, new Object[]{vo});
            executor = this.importExportThreadPoolExecutor.findExportThreadPoolExecutorByKey(poolName);
        } else {
            log.warn("\u8bf7\u68c0\u67e5\u4ee3\u7801\uff1a\u7cfb\u7edf\u53d1\u73b0\u4e0d\u660e\u7c7b\u578b\u52a8\u4f5c\uff01\uff01\uff01ieType={}", (Object)ieType);
        }
        if (executor == null) {
            return;
        }
        executor.submit(run);
    }

    @Override
    public Map<String, Object> findDashboard(String name, String ieType) {
        if (TypeEnum.IMPORT.getDictCode().equals(ieType)) {
            return this.findPoolDashboard(this.importExportThreadPoolExecutor.findImportThreadPoolExecutorByKey(name));
        }
        if (TypeEnum.EXPORT.getDictCode().equals(ieType)) {
            return this.findPoolDashboard(this.importExportThreadPoolExecutor.findExportThreadPoolExecutorByKey(name));
        }
        return Maps.newHashMap();
    }

    @Override
    public Map<String, Set<String>> findPoolNames() {
        Map<String, ThreadPoolExecutor> map0 = this.importExportThreadPoolExecutor.getImportThreadPoolExecutorMap();
        Map<String, ThreadPoolExecutor> map1 = this.importExportThreadPoolExecutor.getExportThreadPoolExecutorMap();
        HashMap re = Maps.newHashMap();
        if (!map0.isEmpty()) {
            re.put("\u5bfc\u5165\u7ebf\u7a0b\u6c60", map0.keySet());
        }
        if (!map1.isEmpty()) {
            re.put("\u5bfc\u51fa\u7ebf\u7a0b\u6c60", map1.keySet());
        }
        return re;
    }

    private Map<String, Object> findPoolDashboard(ThreadPoolExecutor executor) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("\u6838\u5fc3\u7ebf\u7a0b\u6570", executor.getCorePoolSize());
        map.put("\u6700\u5927\u7ebf\u7a0b\u6570", executor.getMaximumPoolSize());
        map.put("\u6267\u884c\u4e2d\u4efb\u52a1\u6570\u91cf", executor.getActiveCount());
        map.put("\u5f85\u6267\u884c\u4efb\u52a1\u6570\u91cf", executor.getQueue().size());
        map.put("\u5df2\u5b8c\u6210\u4efb\u52a1\u6570\u91cf", executor.getCompletedTaskCount());
        map.put("\u603b\u4efb\u52a1\u6570\u91cf", executor.getTaskCount());
        return map;
    }
}

