/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.thread.ExecutorBuilder;
import com.biz.crm.common.ie.local.concurrent.threadpool.priority.FutureTaskComparable;
import com.biz.crm.common.ie.local.concurrent.threadpool.priority.ThreadPoolExecutorPriorityBlocking;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.model.dto.ExportTaskDetailModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.local.model.dto.ImportTaskModelDto;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.local.service.init.ImportExportInitProcessEnvServ;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForExport;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForExportEsParagraph;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForExportGetTotal;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForImport;
import com.biz.crm.common.ie.local.service.task.ImportExportThreadPoolExecutor;
import com.biz.crm.common.ie.local.service.task.cache.ExportTaskCache;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.LoadStatusEnum;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExportEsParagraph;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExportGetTotal;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.datasource.configuration.MultiDataSourceProperties;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="_ImportExportLoadTask")
public class ImportExportLoadTask {
    private static final Logger log = LoggerFactory.getLogger(ImportExportLoadTask.class);
    private static final Lock runLock = new ReentrantLock(true);
    private static LongAdder taskNumForImport = new LongAdder();
    private static LongAdder taskNumForExport = new LongAdder();
    @Autowired
    @Qualifier(value="_importExportThreadPoolExecutor")
    private ImportExportThreadPoolExecutor importExportThreadPoolExecutor;
    @Autowired(required=false)
    private ExportProcessService exportProcessService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ImportTaskService importTaskService;
    @Autowired
    private ExportTaskDetailService exportTaskDetailService;
    @Autowired
    private ExportTaskService exportTaskService;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private ImportExportInitProcessEnvServ importExportInitProcessEnvServ;
    @Autowired
    private MultiDataSourceProperties multiDataSourceProperties;
    @Autowired
    private ExportTaskCache exportTaskCache;
    private static ThreadPoolExecutor poolExe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Transactional
    public void load(String applicationName, Boolean loadFlag) {
        log.debug(loadFlag != false ? "\u8bfb\u53d6\uff1a\u5df2\u52a0\u8f7d\u4efb\u52a1" : "\u8bfb\u53d6\uff1a\u672a\u52a0\u8f7d\u4efb\u52a1");
        boolean tryLock = runLock.tryLock();
        if (!tryLock) {
            return;
        }
        Boolean schemaForTenant = this.multiDataSourceProperties.getSchemaForTenant();
        try {
            if (!schemaForTenant.booleanValue()) {
                log.debug("\u52a0\u8f7d\u5bfc\u5165\u5bfc\u51fa[\u5355\u6570\u636e\u6e90]");
                this.loadTask4Ie(applicationName, loadFlag);
                return;
            }
            List<String> appCodeList = this.importExportInitProcessEnvServ.getAppCodeList();
            log.debug("\u52a0\u8f7d\u5bfc\u5165\u5bfc\u51fa[\u591a\u6570\u636e\u6e90]:{}", (Object)String.join((CharSequence)",", appCodeList));
            int appCodeSize = appCodeList.size();
            if (appCodeSize == 0) {
                return;
            }
            if (poolExe == null) {
                Class<ImportExportLoadTask> clazz = ImportExportLoadTask.class;
                // MONITORENTER : com.biz.crm.common.ie.local.service.task.ImportExportLoadTask.class
                if (poolExe == null) {
                    poolExe = ExecutorBuilder.create().setCorePoolSize(appCodeSize).setMaxPoolSize(100).setWorkQueue(new ArrayBlockingQueue(100)).build();
                }
                // MONITOREXIT : clazz
            }
            CompletableFuture[] runCfArray = new CompletableFuture[appCodeSize];
            for (int idx = appCodeSize - 1; idx >= 0; --idx) {
                String appCode = appCodeList.get(idx);
                runCfArray[idx] = CompletableFuture.runAsync(() -> {
                    log.debug("\u5207\u6362\u79df\u6237\uff1a{}", (Object)appCode);
                    SimpleTenantInfo tenantInfo = new SimpleTenantInfo(appCode);
                    TenantContextHolder.setTenantInfo((AbstractTenantInfo)tenantInfo);
                    this.loadTask4Ie(applicationName, loadFlag);
                }, poolExe);
            }
            CompletableFuture.allOf(runCfArray).join();
            log.debug("\u4efb\u52a1\u52a0\u8f7dOK");
            return;
        }
        finally {
            runLock.unlock();
        }
    }

    private void loadTask4Ie(String applicationName, Boolean loadFlag) {
        boolean haveAsyncGetTotalProcess = this.exportProcessService.isHaveAsyncGetTotalProcess();
        try {
            this.loadTask4Import(applicationName, loadFlag);
        }
        catch (Exception e) {
            log.error("ERROR! ERROR! ERROR! \u52a0\u8f7d\u5bfc\u5165\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
        try {
            this.loadTask4Export(applicationName, loadFlag);
        }
        catch (Exception e) {
            log.error("ERROR! ERROR! ERROR! \u52a0\u8f7d\u5bfc\u51fa\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
        if (haveAsyncGetTotalProcess) {
            try {
                this.loadTask4ExportAsyncGetTotal(applicationName, loadFlag);
            }
            catch (Exception e) {
                log.error("ERROR! ERROR! ERROR! \u52a0\u8f7d\u5bfc\u51fa\u83b7\u53d6\u4efb\u52a1\u603b\u6570\u4efb\u52a1", (Throwable)e);
            }
        }
        try {
            this.loadTask4ExportEsParagraph(applicationName, loadFlag);
        }
        catch (Exception e) {
            log.error("ERROR! ERROR! ERROR! \u52a0\u8f7d\u5bfc\u51fa\u83b7\u53d6\u4efb\u52a1\u603b\u6570\u4efb\u52a1", (Throwable)e);
        }
    }

    private void loadTask4ExportAsyncGetTotal(String applicationName, Boolean loadFlag) {
        log.debug("\u52a0\u8f7d\u5f02\u6b65\u83b7\u53d6\u4efb\u52a1\u603b\u6570\u7ebf\u7a0b\u6c60");
        log.debug(loadFlag != false ? "\u8bfb\u53d6\uff1a\u5df2\u52a0\u8f7d\u3010\u6267\u884c\u4e2d\u3001\u5f85\u6267\u884c\u3011\u5bfc\u51fa\u4efb\u52a1" : "\u8bfb\u53d6\uff1a\u672a\u52a0\u8f7d\u5bfc\u51fa\u4efb\u52a1");
        Map<String, List<ExportTask>> exportTaskMap = this.findExportTaskNoGetTotal(applicationName, loadFlag);
        if (exportTaskMap.isEmpty()) {
            return;
        }
        AbstractTenantInfo tenantInfo = TenantContextHolder.getTenantInfo();
        for (Map.Entry<String, List<ExportTask>> item : exportTaskMap.entrySet()) {
            String appCode = item.getKey();
            List<ExportTask> exportTasklList = item.getValue();
            if (CollectionUtils.isEmpty(exportTasklList)) continue;
            int idx = 0;
            ThreadPoolExecutor threadPoolExecutor = this.importExportThreadPoolExecutor.findExportGetTotalThreadPoolExecutorByKey(appCode);
            for (ExportTask exportTask : exportTasklList) {
                String taskCode = exportTask.getTaskCode();
                if (this.exportTaskCache.checkExecAsyncGetTotalTask(exportTask.getAppCode(), exportTask.getApplicationName(), exportTask.getTaskCode()).booleanValue()) {
                    log.info("\u5bfc\u51fa\u4efb\u52a1{}\u5df2\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5f02\u6b65\u83b7\u53d6\u5bfc\u51fa\u603b\u6570\u7ebf\u7a0b,\u8df3\u8fc7\u6267\u884c", (Object)taskCode);
                    continue;
                }
                IeExecutorVoForExportGetTotal vo = new IeExecutorVoForExportGetTotal();
                vo.setFunctionCode(exportTask.getFunctionCode());
                vo.setParentCode(exportTask.getParentCode());
                vo.setTaskCode(taskCode);
                vo.setAccount(exportTask.getCreateAccount());
                vo.setAccountName(exportTask.getCreateName());
                vo.setTenantCode(exportTask.getTenantCode());
                vo.setAppCode(exportTask.getAppCode());
                vo.setApplicationName(exportTask.getApplicationName());
                vo.setLoadStatus(LoadStatusEnum.YES.getDictCode());
                IeTaskExecutorForExportGetTotal taskExe = (IeTaskExecutorForExportGetTotal)this.applicationContext.getBean(IeTaskExecutorForExportGetTotal.class, new Object[]{vo, exportTask, tenantInfo});
                threadPoolExecutor.submit(taskExe);
                log.debug("{}\u4efb\u52a1\u8fdb\u5165\u5f02\u6b65\u62c6\u5b50\u4efb\u52a1\uff1a{}", (Object)idx++, (Object)taskCode);
                this.exportTaskCache.addExecAsyncGetTotalTask(exportTask.getAppCode(), exportTask.getApplicationName(), exportTask.getTaskCode());
            }
        }
    }

    private void loadTask4ExportEsParagraph(String applicationName, Boolean loadFlag) {
        log.debug("\u52a0\u8f7dES\u5b50\u4efb\u52a1\u5206\u6bb5\u7ebf\u7a0b\u6c60");
        log.debug(loadFlag != false ? "\u8bfb\u53d6\uff1a\u5df2\u52a0\u8f7d\u3010\u6267\u884c\u4e2d\u3001\u5f85\u6267\u884c\u3011\u5bfc\u51fa\u4efb\u52a1" : "\u8bfb\u53d6\uff1a\u672a\u52a0\u8f7d\u5bfc\u51fa\u4efb\u52a1");
        Map<String, List<ExportTask>> exportTaskMap = this.findExportTaskNoEsParagraph(applicationName, loadFlag);
        if (exportTaskMap.isEmpty()) {
            return;
        }
        AbstractTenantInfo tenantInfo = TenantContextHolder.getTenantInfo();
        for (Map.Entry<String, List<ExportTask>> item : exportTaskMap.entrySet()) {
            String appCode = item.getKey();
            List<ExportTask> exportTasklList = item.getValue();
            if (CollectionUtils.isEmpty(exportTasklList)) continue;
            int idx = 0;
            ThreadPoolExecutor threadPoolExecutor = this.importExportThreadPoolExecutor.findExportEsParagraphThreadPoolExecutorByKey(appCode);
            for (ExportTask exportTask : exportTasklList) {
                String taskCode = exportTask.getTaskCode();
                if (this.exportTaskCache.checkExecEsParagraphTask(exportTask.getAppCode(), exportTask.getApplicationName(), exportTask.getTaskCode()).booleanValue()) {
                    log.info("\u5bfc\u51fa\u4efb\u52a1{}\u5df2\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5f02\u6b65\u5206\u6bb5\u5b50\u4efb\u52a1\u7ebf\u7a0b,\u8df3\u8fc7\u6267\u884c", (Object)taskCode);
                    continue;
                }
                IeExecutorVoForExportEsParagraph vo = new IeExecutorVoForExportEsParagraph();
                vo.setFunctionCode(exportTask.getFunctionCode());
                vo.setParentCode(exportTask.getParentCode());
                vo.setTaskCode(taskCode);
                vo.setAccount(exportTask.getCreateAccount());
                vo.setAccountName(exportTask.getCreateName());
                vo.setTenantCode(exportTask.getTenantCode());
                vo.setAppCode(exportTask.getAppCode());
                vo.setApplicationName(exportTask.getApplicationName());
                vo.setLoadStatus(LoadStatusEnum.YES.getDictCode());
                IeTaskExecutorForExportEsParagraph taskExe = (IeTaskExecutorForExportEsParagraph)this.applicationContext.getBean(IeTaskExecutorForExportEsParagraph.class, new Object[]{vo, exportTask, tenantInfo});
                threadPoolExecutor.submit(taskExe);
                log.debug("{}\u4efb\u52a1\u8fdb\u5165\u5f02\u6b65\u5206\u6bb5\u5b50\u4efb\u52a1\uff1a{}", (Object)idx++, (Object)taskCode);
                this.exportTaskCache.addExecEsParagraphTask(exportTask.getAppCode(), exportTask.getApplicationName(), exportTask.getTaskCode());
            }
        }
    }

    private void loadTask4Export(String applicationName, Boolean loadFlag) {
        log.debug(loadFlag != false ? "\u8bfb\u53d6\uff1a\u5df2\u52a0\u8f7d\u3010\u6267\u884c\u4e2d\u3001\u5f85\u6267\u884c\u3011\u5bfc\u51fa\u4efb\u52a1" : "\u8bfb\u53d6\uff1a\u672a\u52a0\u8f7d\u5bfc\u51fa\u4efb\u52a1");
        long threadId = Thread.currentThread().getId();
        Map<String, List<ExportTaskDetail>> exportTaskCodeMap = this.findExportTaskCode(applicationName, loadFlag);
        if (exportTaskCodeMap == null || exportTaskCodeMap.isEmpty()) {
            return;
        }
        AbstractTenantInfo tenantInfo = TenantContextHolder.getTenantInfo();
        HashMap<String, ExportTask> exportTaskMap = new HashMap<String, ExportTask>();
        for (Map.Entry<String, List<ExportTaskDetail>> item : exportTaskCodeMap.entrySet()) {
            String appCode = item.getKey();
            List<ExportTaskDetail> exportTaskDetailList = item.getValue();
            if (CollectionUtils.isEmpty(exportTaskDetailList)) continue;
            int idx = 0;
            Vector<Future> futureTaskList = new Vector<Future>();
            HashSet detailCodeSetByUpdate = Sets.newHashSet();
            HashSet taskCodeSetBySkip = Sets.newHashSet();
            for (ExportTaskDetail task : exportTaskDetailList) {
                String taskCode = task.getTaskCode();
                if (taskCodeSetBySkip.contains(taskCode)) continue;
                String detailCode = task.getDetailCode();
                log.debug("\u5e94\u7528\u6267\u884c\u5bfc\u5165taskCode:{},\u5f53\u524d\u7ebf\u7a0b\u53f7:{}", (Object)taskCode, (Object)threadId);
                ExportTask exportTask = (ExportTask)((Object)exportTaskMap.get(taskCode));
                if (exportTask == null) {
                    exportTask = this.exportTaskService.findExportTask(taskCode);
                    if (exportTask == null) {
                        log.info("\u5e94\u7528\u6267\u884c\u5bfc\u5165taskCode:{},\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u4e3b\u8868\u6570\u636e{}\uff0c\u672c\u6b21\u5faa\u73af\u8df3\u8fc7", (Object)taskCode, (Object)detailCode);
                        taskCodeSetBySkip.add(taskCode);
                        continue;
                    }
                    exportTaskMap.put(taskCode, exportTask);
                }
                String functionCode = exportTask.getFunctionCode();
                String parentCode = exportTask.getParentCode();
                IeExecutorVoForExport vo = new IeExecutorVoForExport();
                vo.setFunctionCode(functionCode);
                vo.setParentCode(parentCode);
                vo.setExportTaskDetailCode(detailCode);
                vo.setTaskCode(taskCode);
                vo.setAccount(task.getCreateAccount());
                vo.setAccountName(task.getCreateName());
                vo.setTenantCode(task.getTenantCode());
                vo.setAppCode(task.getAppCode());
                vo.setApplicationName(task.getApplicationName());
                vo.setTotal(exportTask.getTotal().intValue());
                vo.setTaskSource(exportTask.getTaskSource());
                vo.setLoadStatus(LoadStatusEnum.YES.getDictCode());
                ThreadPoolExecutorPriorityBlocking exportThreadPoolExecutor = this.findExportThreadPoolExecutorByKeyPriorityBlocking(exportTask, appCode);
                IeTaskExecutorForExport taskExe = (IeTaskExecutorForExport)this.applicationContext.getBean(IeTaskExecutorForExport.class, new Object[]{vo, tenantInfo});
                Future exportFuture = exportThreadPoolExecutor.submit(taskExe);
                futureTaskList.add(exportFuture);
                log.debug("{}\u4efb\u52a1\u52a0\u5165\u961f\u5217\uff1a{}", (Object)idx++, (Object)taskCode);
                taskNumForExport.increment();
                detailCodeSetByUpdate.add(detailCode);
            }
            this.exportTaskDetailService.updateLocalStatus(detailCodeSetByUpdate, LoadStatusEnum.YES.getDictCode());
        }
    }

    private void loadTask4Import(String applicationName, Boolean loadFlag) {
        Map<String, List<ImportTask>> importTaskCodeMap = this.findImportTaskCode(applicationName, loadFlag);
        if (importTaskCodeMap == null || importTaskCodeMap.isEmpty()) {
            return;
        }
        HashSet set = Sets.newHashSet();
        Vector futureTaskList = new Vector();
        AbstractTenantInfo tenantInfo = TenantContextHolder.getTenantInfo();
        for (Map.Entry<String, List<ImportTask>> item : importTaskCodeMap.entrySet()) {
            set.addAll((Collection)item.getValue());
            ThreadPoolExecutor importThreadPoolExecutor = this.importExportThreadPoolExecutor.findImportThreadPoolExecutorByKey(item.getKey());
            for (ImportTask task : item.getValue()) {
                IeExecutorVoForImport vo = new IeExecutorVoForImport();
                vo.setTaskCode(task.getTaskCode());
                vo.setAccount(task.getCreateAccount());
                vo.setAccountName(task.getCreateName());
                vo.setTenantCode(task.getTenantCode());
                vo.setAppCode(task.getAppCode());
                vo.setApplicationName(task.getApplicationName());
                vo.setLoadStatus(LoadStatusEnum.YES.getDictCode());
                IeTaskExecutorForImport taskExe = (IeTaskExecutorForImport)this.applicationContext.getBean(IeTaskExecutorForImport.class, new Object[]{vo, tenantInfo});
                Future<?> importFuture = importThreadPoolExecutor.submit(taskExe);
                futureTaskList.add(importFuture);
                taskNumForImport.increment();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            Set<String> taskCodes = set.parallelStream().map(ImportTask::getTaskCode).collect(Collectors.toSet());
            this.importTaskService.updateLocalStatus(taskCodes, LoadStatusEnum.YES.getDictCode());
        }
    }

    private Map<String, List<ImportTask>> findImportTaskCode(String applicationName, Boolean loadFlag) {
        ImportTaskModelDto importTaskModelDto = new ImportTaskModelDto();
        importTaskModelDto.setApplicationName(applicationName);
        if (Boolean.TRUE.equals(loadFlag)) {
            importTaskModelDto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.RUNNING.getDictCode(), ExecStatusEnum.DEFAULT.getDictCode()}));
        } else {
            importTaskModelDto.setLoadStatus(LoadStatusEnum.NO.getDictCode());
        }
        List<ImportTask> result = this.importTaskService.findByImportTaskModelDto(importTaskModelDto);
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        List<Object> list = new ArrayList();
        long importSleep = this.importExportProperties.getImportSleep();
        if (importSleep > 0L) {
            for (ImportTask importTask : result) {
                Date createTime = importTask.getCreateTime();
                Date now = new Date();
                if (now.getTime() - createTime.getTime() < importSleep) continue;
                list.add((Object)importTask);
            }
            log.warn("\u5bfc\u5165\u7b49\u5f85\u65f6\u95f4{}", (Object)(importSleep / 1000L));
            log.warn("\u52a0\u8f7d\u5bfc\u5165\u56e0\u7b49\u5f85\u65f6\u95f4\u8fc7\u6ee4{}\u6761\u6570\u636e", (Object)(result.size() - list.size()));
        } else {
            list = result;
        }
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        if (Boolean.TRUE.equals(this.importExportProperties.getAppFlag())) {
            map.put(applicationName, list);
        } else {
            Map<String, List<ImportTask>> cur = list.parallelStream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getAppCode(), a.getTaskCode()})).collect(Collectors.groupingBy(ImportTask::getAppCode));
            for (Map.Entry<String, List<ImportTask>> item : cur.entrySet()) {
                map.put(applicationName + ":" + item.getKey(), item.getValue());
            }
        }
        return map;
    }

    private Map<String, List<ExportTaskDetail>> findExportTaskCode(String applicationName, Boolean loadFlag) {
        ExportTaskDetailModelDto exportTaskDetailModelDto = new ExportTaskDetailModelDto();
        exportTaskDetailModelDto.setApplicationName(applicationName);
        if (Boolean.TRUE.equals(loadFlag)) {
            exportTaskDetailModelDto.setLoadStatus(LoadStatusEnum.YES.getDictCode());
            exportTaskDetailModelDto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.RUNNING.getDictCode(), ExecStatusEnum.DEFAULT.getDictCode()}));
        } else {
            exportTaskDetailModelDto.setLoadStatus(LoadStatusEnum.NO.getDictCode());
            exportTaskDetailModelDto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.DEFAULT.getDictCode()}));
        }
        List<ExportTaskDetail> list = this.exportTaskDetailService.findByExportTaskDetailModelDto(exportTaskDetailModelDto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        if (Boolean.TRUE.equals(this.importExportProperties.getAppFlag())) {
            map.put(applicationName, list);
        } else {
            Map<String, List<ExportTaskDetail>> cur = list.parallelStream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getAppCode(), a.getDetailCode()})).collect(Collectors.groupingBy(ExportTaskDetail::getAppCode));
            for (Map.Entry<String, List<ExportTaskDetail>> item : cur.entrySet()) {
                map.put(applicationName + ":" + item.getKey(), item.getValue());
            }
        }
        return map;
    }

    private Map<String, List<ExportTask>> findExportTaskNoGetTotal(String applicationName, Boolean loadFlag) {
        ExportTaskModelDto dto = new ExportTaskModelDto();
        dto.setApplicationName(applicationName);
        if (Boolean.TRUE.equals(loadFlag)) {
            dto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode(), ExecStatusEnum.DEFAULT.getDictCode()}));
        } else {
            dto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode()}));
        }
        List<ExportTask> list = this.exportTaskService.findExportTaskNoGetTotal(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        if (Boolean.TRUE.equals(this.importExportProperties.getAppFlag())) {
            map.put(applicationName, list);
        } else {
            Map<String, List<ExportTask>> cur = list.parallelStream().filter(a -> a.getTotal() == null).collect(Collectors.groupingBy(ExportTask::getAppCode));
            for (Map.Entry<String, List<ExportTask>> item : cur.entrySet()) {
                map.put(applicationName + ":" + item.getKey(), item.getValue());
            }
        }
        return map;
    }

    private Map<String, List<ExportTask>> findExportTaskNoEsParagraph(String applicationName, Boolean loadFlag) {
        ExportTaskModelDto dto = new ExportTaskModelDto();
        dto.setApplicationName(applicationName);
        if (Boolean.TRUE.equals(loadFlag)) {
            dto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode(), ExecStatusEnum.DEFAULT.getDictCode()}));
        } else {
            dto.setExecStatusSet(Sets.newHashSet((Object[])new String[]{ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode()}));
        }
        List<ExportTask> list = this.exportTaskService.findExportTaskNoEsParagraph(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        if (Boolean.TRUE.equals(this.importExportProperties.getAppFlag())) {
            map.put(applicationName, list);
        } else {
            Map<String, List<ExportTask>> cur = list.parallelStream().filter(a -> a.getTotal() == null).collect(Collectors.groupingBy(ExportTask::getAppCode));
            for (Map.Entry<String, List<ExportTask>> item : cur.entrySet()) {
                map.put(applicationName + ":" + item.getKey(), item.getValue());
            }
        }
        return map;
    }

    private ThreadPoolExecutorPriorityBlocking findExportThreadPoolExecutorByKeyPriorityBlocking(ExportTask exportTask, String appCode) {
        Integer total = exportTask.getTotal();
        if (total >= this.importExportThreadPoolExecutor.getLargeExportTaskDataNum()) {
            return this.importExportThreadPoolExecutor.findLargeExportThreadPoolExecutorByKeyPriorityBlocking(appCode);
        }
        if (total >= this.importExportThreadPoolExecutor.getMediumExportTaskDataNum() && total < this.importExportThreadPoolExecutor.getLargeExportTaskDataNum()) {
            return this.importExportThreadPoolExecutor.findMediumExportThreadPoolExecutorByKeyPriorityBlocking(appCode);
        }
        return this.importExportThreadPoolExecutor.findSmallExportThreadPoolExecutorByKeyPriorityBlocking(appCode);
    }

    public static LongAdder getTaskNumForImport() {
        return taskNumForImport;
    }

    public static LongAdder getTaskNumForExport() {
        return taskNumForExport;
    }

    private static /* synthetic */ void lambda$loadTask4Import$2(Future exportFuture) {
        try {
            Object x = exportFuture.get();
            System.out.println(x);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            taskNumForImport.decrement();
        }
    }

    private static /* synthetic */ void lambda$loadTask4Export$1(FutureTaskComparable exportFuture) {
        try {
            Object x = exportFuture.get();
            if (x == null) {
                IeTaskExecutorForExport comparable = (IeTaskExecutorForExport)exportFuture.getComparable();
                System.out.println(comparable);
            }
            System.out.println(x);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            taskNumForExport.decrement();
        }
    }
}

