package com.biz.crm.common.ie.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author Kevin
 * @title ExportWebApiDto
 * @date 2023/10/8 14:44
 * @description webApi导出参数
 */
@Data
@ApiModel(value = "ExportWebApiDto",description = "webApi导出参数")
public class ExportWebApiDto {
  /**
   * 解析的URL地址
   */
  @ApiModelProperty("解析的url地址")
  private String webApiUrl;

  /**
   * url地址对应的方法的类型（POST、GET）
   */
  @ApiModelProperty("url地址映射的类型")
  private String requestMapping;

  /**
   * 起始页码，0/1
   * */
  @ApiModelProperty("初始页码 0/1")
  private int startPage = 0;
}
