package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导入导出任务执行状态
 *
 * @author sunx
 * @date 2022/5/12
 */
@AllArgsConstructor
@Getter
public enum ExecStatusEnum {
  /** 执行中 */
  RUNNING("0", "0", "执行中", "0"),
  /** 初始化导出任务明细，执行完成任务状态修改为DEFAULT */
  NEED_EXPORT_TASK_DETAIL("2", "2", "待初始化子任务", "2"),
  /** 待执行 */
  DEFAULT("5", "5", "待执行", "5"),
  /** 已完成 */
  FINISH("15", "15", "已完成", "10"),
  /** 已取消 */
  CANCEL("20", "20", "已取消", "20"),
  /** 已失败 */
  FAILED("25", "25", "已失败", "25"),
  /** 部分成功 */
  PARTIAL_SUCCESS("30", "30", "部分成功", "30"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
