package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导出阶段枚举（子任务）
 *
 * @author sunx
 * @date 2022/5/16
 */
@AllArgsConstructor
@Getter
public enum ExportDetailProcessEnum {
  /** 导出阶段枚举 */
  START("start", "开始", "子任务开始处理......"),
  RUNNING("running", "文件生成", "子任务文件生成中......"),
  UPLOAD("upload", "文件上传", "子任务文件上传中……"),
  END("end", "完成", "子任务导出完成"),
  ;
  /** code */
  private String code;
  /** 字典编码 */
  private String desc;
  /** 消息格式 */
  private String format;
}
