package com.biz.crm.common.ie.sdk.excel.strategy;

import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.exception.CrmExportException;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskDetailVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 导入导出excel处理策略接口
 *
 * @author sunx
 * @date 2022/6/8
 */
public interface CrmExcelProcessStrategy {
  
  /**
   * 获取错误Excel文件名
   * 
   * @param fileName 正常文件名
   * @return 错误文件名
   */
  default String getErrorExcelFileName(String fileName) {
    String onlyFileName = fileName.substring(0, fileName.lastIndexOf('.'));
    String errorFileName = onlyFileName + ImportExportConstant.IE_ERROR_FILE_SUFFIX;
    return errorFileName;
  }

  /**
   * 导入任务
   *
   * @param process 自定义处理器
   * @param paramsVo 任务公共参数
   * @param params 导入任务自定义参数
   * @param localFile 导入任务文件信息(导入源文件\模板文件\错误文件)
   * @return
   */
  default ImportTaskHandlerResultVo importExcel(
      ImportProcess<?> process,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params,
      ImportExcelLocalFile localFile) {
    Map<String, ExcelFileVo> fileMap = localFile.convertFileMap();
    return this.importExcel(process, paramsVo, params, fileMap);
  }
  
  /**
   * 导入任务
   *
   * @param process 自定义处理器
   * @param paramsVo 任务公共参数
   * @param params 导入任务自定义参数
   * @param localFile 导入任务文件信息(导入源文件+模板文件\错误文件)
   * @return
   */
  ImportTaskHandlerResultVo importExcel(
      ImportProcess process,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params,
      Map<String, ExcelFileVo> fileMap);

  /**
   * 导出子任务
   *
   * @param task 导出子任务参数
   * @param process 自定义处理器
   * @param paramsMap 自定义参数
   * @param filePath 临时文件路径
   */
  void exportDetail(
      ExportTaskProcessVo task,
      ExportProcess process,
      Map<String, Object> paramsMap,
      String filePath);
  /**
   * 导出子任务
   *
   * @param task 导出子任务参数
   * @param process 自定义处理器
   * @param paramsMap 自定义参数
   * @param filePath 临时文件路径
   * @param funPermVo 功能菜单权限，用于查询当前可以导出的列信息
   * @throws CrmExportException 
   */
  void exportDetailForEuropa(ExportTaskProcessVo task, ExportProcess<?> process, Map<String, Object> paramsMap,
      String tmpFilePath, FunctionPermissionVo funPermVo) throws CrmExportException;

  /**
   * 导出主任务合并
   *
   * @param task 主任务信息
   * @param process 自定义处理器
   * @param parentPath 主任务临时文件路径
   * @param list 待合并的子任务明细信息
   * @param detailFilePathMap k-子任务编码，v-子任务导出文件路径
   * @return k-合并生成文件名，v-文件路径
   */
  LinkedHashMap<String, String> merge(
      ExportTaskProcessVo task,
      ExportProcess process,
      String parentPath,
      List<ExportTaskDetailVo> list,
      Map<String, String> detailFilePathMap);


  /**
   * webApi导出子任务
   * @param task 导出子任务参数
   * @param process 自定义处理器
   * @param paramsMap 自定义参数
   * @param absolutePath 临时文件路径
   * @param functionPermissionVo 功能菜单权限，用于查询当前可以导出的列信息
   */
  void exportDetailForWebApi(ExportTaskProcessVo task, ExportProcess<?> process, Map<String, Object> paramsMap,
      String absolutePath, FunctionPermissionVo functionPermissionVo) throws CrmExportException;
}
