package com.biz.crm.common.ie.sdk.excel.strategy;

import cn.hutool.json.JSONObject;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 导出数据字段过滤策略(全局配置，针对当前应用中所有的导出业务均使用)
 * 主要用户过滤用户个性化设置以及页面引擎中配置的非导出字段的过滤功能
 * 2023-07-26 因为新增需求并且为了新旧版本的兼容性，新重载了 List<ColumnVo> getShowDataviewColumn(String parentCode, String functionCode, String paramsJson)方法
 * 并且将（不包括getShowDataviewColumn(FunctionPermissionVo funPermVo)）getShowDataviewColumn进行了默认方法更改。
 *
 * @author keller
 */
public interface CrmExportColumnStrategy {

  /**
   * 需要导出的字段名称
   *
   * @return
   */
  Set<String> exportColumn(ExportTaskProcessVo vo);

  /**
   * 获取显示的数据视图字段
   * 为了考虑新旧版本的兼容性! 2023-07-26之前数据视图导出策略重写的当前方法
   * @param parentCode
   * @param functionCode
   * @return
   */
 default List<ColumnVo> getShowDataviewColumn(String parentCode, String functionCode){
   return  new ArrayList<>(0);
 }

  /**
   * 获取显示的数据视图字段
   * 为了考虑新旧版本的兼容性! 2023-07-26之后数据视图导出策略重写的当前方法
   * @param parentCode
   * @param functionCode
   * @param paramsJson 可能需要的拓展参数
   * @return
   */
  default List<ColumnVo> getShowDataviewColumn(String parentCode, String functionCode, String paramsJson) {
    return  new ArrayList<>(0);
  }

  /**
   * 获取显示的数据视图字段
   *
   * @param funPermVo （parentCode，functionCode）
   * @return
   */
  List<ColumnVo> getShowDataviewColumn(FunctionPermissionVo funPermVo);

  /**
   * 填充数据字典
   *
   * @param excelDataList
   * @param showDataviewColumn
   * @param 数据字典替换关键字段后返回数据
   */
  List<JSONObject> fullDictCode(List<JSONObject> excelDataList, List<ColumnVo> showDataviewColumn);
}
