package com.biz.crm.common.ie.sdk.excel.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import com.google.common.collect.Maps;
import cn.hutool.core.util.StrUtil;

/**
 * 将europa参数进行转换的工具类
 * 
 * @author Ken
 * @version 1.0 Copyright 2022年12月2日 下午3:35:29
 */
public class EuropaParamsTools {
  public static final String   EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";
  private static final Pattern europaPattern              = Pattern.compile("(_\\d+)$");
  
  /**
   * 是否是europa表单传递过来的参数
   * 
   * @param params
   * @return
   */
  public static boolean isEuropaParam(Map<String, Object> params) {
    return params.containsKey(EUROPA_CODE_PARAMETER_NAME);
  }
  
  /**
   * 将europa参数转换为驼峰模式的参数
   * 
   * @param europaParams
   * @return
   */
  public static Map<String, Object> convertEuropaParam(Map<String, Object> params) {
    if (EuropaParamsTools.isEuropaParam(params) == false) {
      // 不是动态表单传递过来的参数
      return params;
    }
    // 是动态表单传递过来的参数
    Map<String, Object> map = Maps.newHashMap();
    params.forEach((key, value) -> {
      String handleKey = key;
      Matcher matcher = europaPattern.matcher(key);
      if (matcher.find()) {
        // 是动态表单传递参数
        // step1：去掉最后的下划线和数字
        String subString = matcher.replaceAll("");
        // step2：下划线转驼峰
        handleKey = StrUtil.toCamelCase(subString);
      }
      map.put(handleKey, value);
    });
    return map;
  }
}
