package com.biz.crm.common.ie.sdk.vo;

import java.util.Map;
import com.biz.crm.common.ie.sdk.enums.ExcelFileTypeEnum;
import com.google.common.collect.Maps;
import lombok.Data;

/**
 * 一次导入操作本地文件信息
 */
@Data
public class ImportExcelLocalFile {
  /** 导入原文件[本地临时文件类型] */
  ExcelFileVo ordinaryFile;
  /** 导入模板 */
  ExcelFileVo templateFile;
  /** 错误文件 */
  ExcelFileVo errorFile;

  /**
   * 将map对象转换为ImportExcelLocalFile对象
   * 
   * @param fileMap
   * @return
   */
  public static ImportExcelLocalFile convertLocalFile(Map<String, ExcelFileVo> fileMap) {
    ImportExcelLocalFile localFile = new ImportExcelLocalFile();
    localFile.errorFile = fileMap.get(ExcelFileTypeEnum.ERROR);
    localFile.ordinaryFile = fileMap.get(ExcelFileTypeEnum.ORIGINAL);
    localFile.templateFile = fileMap.get(ExcelFileTypeEnum.TEMPLATE);
    return localFile;
  }

  /**
   * 将当前对象转换为Map，兼容CrmExcelProcessStrategy接口
   * 
   * @return
   */
  public Map<String, ExcelFileVo> convertFileMap() {
    Map<String, ExcelFileVo> fileMap = Maps.newHashMap();
    fileMap.put(ExcelFileTypeEnum.ERROR.getDictCode(), this.errorFile);
    fileMap.put(ExcelFileTypeEnum.ORIGINAL.getDictCode(), this.ordinaryFile);
    fileMap.put(ExcelFileTypeEnum.TEMPLATE.getDictCode(), this.templateFile);
    return fileMap;
  }
}
