package com.biz.crm.common.ie.sdk.enums;

import java.util.Arrays;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author ning.zhang
 * @description 导入导出任务回调状态
 * @date 2024/9/18
*/
@AllArgsConstructor
@Getter
public enum CallbackStatusEnum {
  /** 已经执行成功回调 */
  HAVE_CALL_BACK_SUCCESS("have_call_back_success", "have_call_back_success", "已经执行成功回调", "0"),
  /** 已经执行部分成功回调 */
  HAVE_CALL_BACK_PARTIAL_SUCCESS("have_call_back_partial_success", "have_call_back_partial_success", "已经执行部分成功回调", "10"),
  /** 已经执行失败回调 */
  HAVE_CALL_BACK_FAIL("have_call_back_fail", "have_call_back_fail", "已经执行失败回调", "20"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过字典编码获取 枚举值
   *
   * @param dictCode 字典编码
   * @return 枚举值
   */
  public static CallbackStatusEnum getByDictCode(String dictCode) {
    return Arrays.stream(CallbackStatusEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode)).findFirst().orElse(null);
  }
}
