package com.biz.crm.common.ie.sdk.utils;

import java.util.HashMap;
import java.util.TimeZone;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 导入导出使用的Json转换工具
 * 
 * @author Ken
 * @version 1.0 Copyright 2023年1月3日 下午4:38:19
 */
public class IeJsonUtils {
  private static volatile Gson gson;

  static {
    if (gson == null) {
      synchronized (IeJsonUtils.class) {
        if (gson == null) {
          try {
            TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
          } catch (Exception e) {
            System.err.println("系统初始化时，创建北京时区有问题");
          }
          gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();

        }
      }
    }
  }

  /**
   * 对日期格式进行格式化
   * 
   * @return
   */
  public static Gson getGson() {
    return gson;
  }

  /**
   * 对日期格式进行格式化
   * 
   * @param results
   * @return
   */
  public static String toJsonString(Object results) {
      return getGson().toJson(results);
  }

  /**
   * 对日期格式进行格式化
   * 
   * @param results
   * @return
   */
  public static JSONArray toJSONArray(Object results) {
    String jsonString = toJsonString(results);
    return JSON.parseArray(jsonString);
  }

  public static HashMap fromJson(String jsonStr, Class<HashMap> clazz) {
      return getGson().fromJson(jsonStr, clazz);
  }
}
