package com.biz.crm.common.ie.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ning.zhang
 * @description 导出任务事件VO
 * @date 2024/09/18
 */
@Data
public class ExportTaskEventVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -3898587398305759742L;

  /** 导出任务编码 */
  @ApiModelProperty("导出任务编码")
  private String taskCode;

  /** 任务名称 */
  @ApiModelProperty("任务名称")
  private String taskName;

  /** 业务编码 */
  @ApiModelProperty("业务编码")
  private String businessCode;

  /** 文件来源 */
  @ApiModelProperty("文件来源")
  private String taskSource;

  /** 总记录数 */
  @ApiModelProperty("总记录数")
  private Integer total;

  /** 导出任务全局参数 */
  @ApiModelProperty("导出任务全局参数")
  private String parametersJson;

  /** 任务执行状态 */
  @ApiModelProperty("任务执行状态")
  private String execStatus;

  /** 应用名称 */
  @ApiModelProperty("应用名称")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  private String appCode;

  /** 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  private String marsListCode;

  /** 个性化设置以及导出字段需要使用菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用菜单编号")
  private String functionCode;

  /** 个性化设置以及导出字段需要使用上级菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用上级菜单编号")
  private String parentCode;

  /** 回调状态-执行成功或者失败回调状态 */
  @ApiModelProperty("回调状态-执行成功或者失败回调状态")
  private String callBackStatus;

  /** 导出文件名称 */
  @ApiModelProperty("导出文件名称")
  private String fileName;

  /**
   * 请求的url地址
   */
  @ApiModelProperty("请求的url地址")
  private String webApiUrl;
}
