package com.biz.crm.common.ie.sdk.vo;

import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 导入任务进度消息
 *
 * @author sunx
 * @date 2022/5/16
 */
@Data
@ApiModel(value = "ImportProcessMsgVo", description = "导入任务进度消息")
public class ImportProcessMsgVo {
  /** 任务编码 */
  @ApiModelProperty("任务编码")
  private String taskCode;
  /** 是否是主任务 */
  @ApiModelProperty("是否是主任务")
  private Boolean mainFlag = true;
  /**
   * 导入导出类型
   *
   * @see TypeEnum
   */
  @ApiModelProperty("导入导出类型,0-导入，1-导出")
  private String ieType = TypeEnum.IMPORT.getDictCode();
  /**
   * 执行状态
   *
   * @see ExecStatusEnum
   */
  @ApiModelProperty("执行状态，0-执行中，15-已完成，25-已失败")
  private String execStatus;
  /**
   * 进度类型
   *
   * @see ImportProcessEnum
   */
  @ApiModelProperty("进度类型")
  private String processType;
  /** 第几页 */
  @ApiModelProperty("第几页")
  private Integer page;
  /** 页大小 */
  @ApiModelProperty("页大小")
  private Integer pageSize;
  /** 当前页进度 */
  @ApiModelProperty("当前页进度")
  private Integer cursor;
  /** 备注 */
  @ApiModelProperty("备注")
  private String remark;
  /** 时间 */
  @ApiModelProperty("时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "create_time", length = 20, columnDefinition = "DATE")
  private Date time;
  /** 执行账号 */
  private String account;

  /**
   * 所属系统名称
   */
  @ApiModelProperty("所属系统名称")
  private String applicationName;

  /** 失败文件编码 */
  @ApiModelProperty("失败文件编码")
  private String fileCode;

  /** 导出文件名称 */
  @ApiModelProperty("导出文件名称")
  private String fileName;

}
