package com.biz.crm.common.ie.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ning.zhang
 * @description 导入任务事件VO
 * @date 2024/09/18
 */
@Data
public class ImportTaskEventVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -2972167019543078385L;

  /** 导入任务编码 */
  @ApiModelProperty("导入任务编码")
  private String taskCode;

  /** 任务名称 */
  @ApiModelProperty("任务名称")
  private String taskName;

  /** 业务编码 */
  @ApiModelProperty("业务编码")
  private String businessCode;

  /** 文件来源 */
  @ApiModelProperty("文件来源")
  private String taskSource;

  /** 模板编码 */
  @ApiModelProperty("模板编码")
  private String templateCode;


  /** 上传文件编码 */
  @ApiModelProperty("上传文件编码")
  private String fileCode;

  /** 上传处理参数 */
  @ApiModelProperty("上传处理参数")
  private String parametersJson;

  /**
   * 任务执行状态
   */
  @ApiModelProperty("任务执行状态")
  private String execStatus;

  /**
   * 数据导入状态
   */
  @ApiModelProperty("导入数据行状态")
  private String importDataStatus;

  /**
   * 任务加载状态
   */
  @ApiModelProperty("任务加载状态")
  private String loadStatus;

  /** 总数 */
  @ApiModelProperty("总数")
  private Integer total;

  /** 失败记录数 */
  @ApiModelProperty("失败记录数")
  private Integer failedNum;

  /** 失败文件编码 */
  @ApiModelProperty("失败文件编码")
  private String failedFileCode;

  /** 应用 */
  @ApiModelProperty("应用")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  private String appCode;

  /** 回调状态-执行成功或者失败回调状态 */
  @ApiModelProperty("回调状态-执行成功或者失败回调状态")
  private String callBackStatus;
}
