package com.biz.crm.common.ie.sdk.event;

import com.biz.crm.common.ie.sdk.vo.ImportTaskEventVo;

/**
 * @author ning.zhang
 * @description 导入通知事件监听器(导入结果通知上层业务事件)
 * @date 2024/09/14
 */
public interface ImportNotifyEventListener {

  /**
   * 当导出任务执行成功之后触发
   *
   * @param eventVo 导出任务信息
   */
  void onSuccess(ImportTaskEventVo eventVo);

  /**
   * 当导出任务部分执行成功之后触发
   *
   * @param eventVo 导出任务信息
   */
  void onPartialSuccess(ImportTaskEventVo eventVo);

  /**
   * 当导出任务执行失败之后触发
   *
   * @param eventVo 导出任务信息
   */
  void onFail(ImportTaskEventVo eventVo);
}
