package com.biz.crm.common.ie.sdk.strategy;

import cn.hutool.json.JSONObject;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;

import java.util.List;
import java.util.Set;

/**
 * @author HanJiaJun
 * @describe: 数据视图导出字段获取策略，仅能限数据视图导出
 * @createTime 2023年07月25日 17:01:00
 */
public interface ExportColumnStrategy {

  /**
   * 策略编码 全局唯一
   * @return
   */
  String getCode();

  /**
   * 策略名称
   * @return
   */
  String getName();

  /**
   * 获取字段
   * @param marsField 数据权限允许的字段，无论策略如何写，如果set存在值那么最后产生的字段都只能是在这个set范围内的！！
   * @param jsonObject 可能的参数
   * @return
   * 返回的应该是最终需要和页面配置的导出字段以及数据权限运行的字段进行比对
   */
  List<ColumnVo> getColumn(Set<String> marsField, JSONObject jsonObject);
}
