/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.process;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.enums.WriteErrorExcelModelEnums;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public interface ImportProcess<T extends CrmExcelVo> {
    public static final ThreadLocal<List<String>> errorListLocal = new ThreadLocal();

    default public Integer getBatchCount() {
        return 1;
    }

    default public boolean importBeforeValidationFlag() {
        return false;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, T> var1, TaskGlobalParamsVo var2, Map<String, Object> var3);

    default public Map<Integer, String> tryVerify(LinkedHashMap<Integer, T> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        return null;
    }

    default public Map<Integer, String> tryConfirm(LinkedHashMap<Integer, T> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        return this.execute(data, paramsVo, params);
    }

    public Class<T> findCrmExcelVoClass();

    default public String getBusinessCode() {
        return "";
    }

    default public String getBusinessName() {
        return "";
    }

    public String getTemplateCode();

    public String getTemplateName();

    default public int order() {
        return 0;
    }

    default public Map<String, Object> getGlobalParams() {
        HashMap map = Maps.newHashMap();
        map.put("ie_create_time", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return map;
    }

    default public WriteErrorExcelModelEnums getWriteErrorExcelModel() {
        return WriteErrorExcelModelEnums.ONLY_ERROR_ROW;
    }

    public static List<String> getThreadErrorList() {
        List<String> list = errorListLocal.get();
        if (list == null) {
            list = new ArrayList<String>();
            errorListLocal.set(list);
        }
        return list;
    }

    default public void validateIsTrue(boolean isTrue, String errorMsg) {
        if (!isTrue) {
            List<String> errorList = ImportProcess.getThreadErrorList();
            errorList.add(errorMsg);
        }
    }

    default public void validateCheck(String separator) throws IllegalArgumentException {
        String errorInfo;
        if (separator == null) {
            separator = " ";
        }
        Validate.isTrue(((errorInfo = this.validateGetErrorInfo(separator)) == null ? 1 : 0) != 0, (String)errorInfo, (Object[])new Object[0]);
    }

    default public String validateGetErrorInfo(String separator) {
        List<String> errorList = errorListLocal.get();
        if (!CollectionUtils.isEmpty(errorList)) {
            errorListLocal.remove();
            return StringUtils.join(errorList, (String)separator);
        }
        return null;
    }

    default public String validateGetErrorInfo() {
        return this.validateGetErrorInfo(" ");
    }

    default public void validateCheck() throws IllegalArgumentException {
        this.validateCheck(" ");
    }

    default public Integer getLimitRowNum() {
        return ImportExportConstant.IE_IMPORT_LIMIT_ROW_NUM;
    }
}

