/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public class BzExcelUtil {
    private BzExcelUtil() {
    }

    public static void setCrmExcelVoValue(CrmExcelVo vo, List<Object> values) {
        int i;
        if (CollUtil.isEmpty(values)) {
            return;
        }
        CrmExcelImport crmExcelImport = vo.getClass().getAnnotation(CrmExcelImport.class);
        int fieldNum = vo.getClass().getDeclaredFields().length;
        Validate.isTrue((crmExcelImport.startColumn() <= fieldNum ? 1 : 0) != 0, (String)"\u5f00\u59cb\u89e3\u6790\u5217\u7d22\u5f15\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5904\u7406bean\u7684\u5b57\u6bb5\u6570", (Object[])new Object[0]);
        int startColumn = crmExcelImport.startColumn();
        int endColumn = crmExcelImport.endColumn();
        endColumn = endColumn == -1 ? fieldNum - 1 : Integer.max(startColumn, endColumn);
        List<CrmExcelColumnField> fields = BzExcelUtil.findCrmExcelColumnField(vo.getClass());
        if (CollUtil.isEmpty(fields)) {
            return;
        }
        HashMap map = Maps.newHashMap();
        int size = values.size();
        size = Integer.min(size, fieldNum);
        for (i = 0; i < size; ++i) {
            map.put(i, values.get(i));
        }
        for (i = 0; i < fields.size(); ++i) {
            CrmExcelColumnField item = fields.get(i);
            Object value = map.get(i);
            if (i < startColumn || i > endColumn || value == null) continue;
            Field field = item.getField();
            try {
                ReflectUtil.setFieldValue((Object)vo, (Field)field, value);
                continue;
            }
            catch (Exception e) {
                Validate.isTrue((boolean)false, (String)CharSequenceUtil.format((CharSequence)"\u5bf9\u8c61\u5b57\u6bb5{}\u8d4b\u503c\u9519\u8bef", (Object[])new Object[]{field.getName()}), (Object[])new Object[0]);
            }
        }
    }

    public static void setCrmExcelVoValue(CrmExcelVo vo, Map<Integer, Object> data) {
        if (data.isEmpty()) {
            return;
        }
        LinkedList values = Lists.newLinkedList();
        for (Map.Entry<Integer, Object> item : data.entrySet()) {
            values.add(item.getValue());
        }
        BzExcelUtil.setCrmExcelVoValue(vo, values);
    }

    public static List<List<String>> findCrmExcelExportTitle(Class<?> crmExcelVoClass) {
        LinkedList list = Lists.newLinkedList();
        List<CrmExcelColumnField> fields = BzExcelUtil.findCrmExcelColumnField(crmExcelVoClass);
        if (CollUtil.isEmpty(fields)) {
            return list;
        }
        for (CrmExcelColumnField field : fields) {
            list.add(Arrays.asList(field.getTitle()));
        }
        return list;
    }

    public static List<CrmExcelColumnField> findCrmExcelColumnField(Class<?> crmExcelVoClass) {
        Field[] fields = ReflectUtil.getFields(crmExcelVoClass);
        ArrayList list = Lists.newArrayList();
        Stream.of(fields).filter(a -> Objects.nonNull(a.getAnnotation(CrmExcelColumn.class))).forEach(a -> {
            CrmExcelColumnField cur = new CrmExcelColumnField();
            cur.setField((Field)a);
            cur.setColumn(a.getAnnotation(CrmExcelColumn.class));
            cur.setOrder(cur.getColumn().order());
            String[] title = cur.getColumn().value();
            cur.setTitle(title);
            if (cur.getTitle() == null || cur.getTitle().length == 0) {
                cur.setTitle(new String[]{cur.getField().getName()});
            }
            list.add(cur);
        });
        return list.stream().sorted(Comparator.comparing(CrmExcelColumnField::getOrder)).collect(Collectors.toList());
    }

    public static Integer findMsgCount(Integer total) {
        if ((total = Integer.valueOf(Integer.max(Optional.ofNullable(total).orElse(0), 0))) < 10) {
            return 10;
        }
        if (total < 500) {
            return 25;
        }
        if (total < 2000) {
            return 100;
        }
        if (total < 10000) {
            return 500;
        }
        return 1000;
    }

    public static class CrmExcelColumnField {
        private String[] title;
        private Field field;
        private Integer order;
        private CrmExcelColumn column;

        public String[] getTitle() {
            return this.title;
        }

        public Field getField() {
            return this.field;
        }

        public Integer getOrder() {
            return this.order;
        }

        public CrmExcelColumn getColumn() {
            return this.column;
        }

        public void setTitle(String[] title) {
            this.title = title;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public void setColumn(CrmExcelColumn column) {
            this.column = column;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CrmExcelColumnField)) {
                return false;
            }
            CrmExcelColumnField other = (CrmExcelColumnField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$order = this.getOrder();
            Integer other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getTitle(), other.getTitle())) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            CrmExcelColumn this$column = this.getColumn();
            CrmExcelColumn other$column = other.getColumn();
            return !(this$column == null ? other$column != null : !this$column.equals(other$column));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CrmExcelColumnField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getTitle());
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            CrmExcelColumn $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            return result;
        }

        public String toString() {
            return "BzExcelUtil.CrmExcelColumnField(title=" + Arrays.deepToString(this.getTitle()) + ", field=" + this.getField() + ", order=" + this.getOrder() + ", column=" + this.getColumn() + ")";
        }
    }
}

