package com.biz.crm.common.ie.sdk.excel.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * crm excel 导入bean注解
 *
 * @author sunx
 * @date 2022/5/12
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface CrmExcelImport {

  /** 开始sheet,0标识第一个sheet */
  int sheetNo() default 0;

  /** 开始解析行数索引，0标识从第一行开始，1默认title占一行 */
  int startRow() default 1;

  /** 开始解析列数索引,0标识从第一列开始 */
  int startColumn() default 0;

  /** 结束解析列数索引 */
  int endColumn() default -1;
}
