package com.biz.crm.common.ie.sdk.excel.process;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.util.EuropaParamsTools;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.utils.IeJsonUtils;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

/**
 * 导出基座<br/>
 * 
 *
 * @author sunx
 * @date 2022/5/12
 * @see ExportProcess
 */
public interface ExportProcess<T extends CrmExcelVo> {
  /**
   * 获取当前getTotal是否是异步方法，如果是异步，则getTotal将会进入异步线程处理
   * @return true:异步获取总数，false：同步获取总数【默认值】
   */
  public default boolean isAsyncGetTotal() {
    return false;
  }
  /**
   * 获取当前任务需要导出数据总记录数(用于拆分子任务)
   * 存在多租户问题，建议尽快变更
   * @param params 自定义参数
   * @return
   */
  Integer getTotal(Map<String, Object> params);
  
  /**
   * 数据处理（最终处理）
   *
   * @param vo 导出任务处理器实体信息
   * @param params 扩展参数
   * @return
   */
  JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params);
  
  /**
   * 导出业务编码
   *
   * @return
   */
  String getBusinessCode();
  
  /**
   * 导出业务名称
   *
   * @return
   */
  String getBusinessName();

  /**
   * 获取上传任务的文件名,默认返回null
   *
   * @param task
   * @return
   */
  default String getTaskFileName(ExportTaskProcessVo task){
    return null;
  }

  /**
   * 拆分子任务size
   *
   * @return
   */
  default Integer getPageSize() {
    return ImportExportConstant.IE_EXPORT_PAGE_SIZE;
  }

  /**
   * 分页查询分页大小
   *
   * @return
   */
  default Integer getQueryPageSize() {
    return ImportExportConstant.IE_EXPORT_QUERY_PAGE_SIZE;
  }

  /**
   * 获取合并文件最大条数(超过该数值将不会合并文件,如果是null或者小于等于0则不会限制无论多少条都会合并)
   *
   * @return
   */
  default Integer getMergeFileMaxCount() {
    return null;
  }
  

  /**
   * 获取用户自定义任务扩展参数（在新建导出任务的时候使用，如果实现会将返回数据存入任务数据库）
   *
   * @return
   */
  default Map<String, Object> getGlobalParams() {
    Map<String, Object> map = Maps.newHashMap();
    map.put(
        ImportExportConstant.IE_PARAMS_CREATE_TIME,
        DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    return map;
  }
  
  /**
   * 获取对象转换实体
   *
   * @return
   */
  default Class<T> findCrmExcelVoClass() {
    Type[] genericInterfaces = getClass().getGenericInterfaces();
    Class<T> clazz = (Class<T>)((ParameterizedType) genericInterfaces[0]).getActualTypeArguments()[0];
//    Class<T> clazz = (Class<T>) ((ParameterizedType) class1.getGenericSuperclass()).getActualTypeArguments()[0];
    return clazz;
  }
  
  /**
   * 将europa参数(position_name_1664185318683)转换为驼峰模式的参数(positionName)
   * 
   * @param params
   * @return
   */
  default Map<String, Object> convertEuropaParam(Map<String, Object> params) {
    return EuropaParamsTools.convertEuropaParam(params);
  }

  /**
   * 将对象转换为JSON对象（日期格式化为北京时区）
   * 
   * @param list
   * @return
   */
  default JSONArray toJSONArray(List<?> list) {
    JSONArray jsonArray = IeJsonUtils.toJSONArray(list);
    return jsonArray;
  }

  /**
   * 构建分页查询参数
   *
   * @param params 导出参数
   * @return 分页查询参数
   */
  default Pageable buildPageable(Map<String, Object> params) {
    int pageNo = (int) params.get(ImportExportConstant.IE_EXPORT_COMMON_PARAM_PAGE_NO);
    int pageSize = (int) params.get(ImportExportConstant.IE_EXPORT_COMMON_PARAM_PAGE_SIZE);
    return PageRequest.of(pageNo, pageSize);
  }

  /**
   * 自定义导出导出模板类的字段是否与数据视图列权限和页面配置字段取交集
   *
   * @return true:取交集,false:不取交集(不用关心据视图列权限和页面配置字段)
   */
  default Boolean isColumnUniteMarsAndConfig() {
    return Boolean.TRUE;
  }
}
