package com.biz.crm.common.ie.sdk.vo;

import java.util.Date;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import lombok.Data;

/**
 * 导入导出任务公共参数
 *
 * @author sunx
 * @date 2022/6/8
 */
@Data
public class TaskGlobalParamsVo {
  /** 任务编码 */
  private String taskCode;
  /** 顶级租户编码 */
  private String appCode;
  /** 应用名称 */
  private String applicationName;
  /** 租户编码 */
  private String tenantCode;
  /** 账号 */
  private String createAccount;
  /** 操作人名 */
  private String createAccountName;
  /** 任务创建时间 */
  private Date taskCreateTime;
  /** 用户登陆对象[用于生成jwt必须得资料] */
  private Authentication authentication;

  public TaskGlobalParamsVo() {
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    this.authentication = authentication;
  }

  /**
   * 还原登陆使用的JWT环境
   */
  public void setContextSecurityContext() {
    Authentication auth = SecurityContextHolder.getContext().getAuthentication();
    if (auth == null) {
      SecurityContextHolder.getContext().setAuthentication(this.authentication);
    }
  }

  public String getTenantCode() {
//    this.setContextSecurityContext();
    return this.tenantCode;
  }
}
