/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.itextpdf.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.itextpdf.sdk.dto.ITextPdfDto;
import com.biz.crm.dms.business.itextpdf.sdk.dto.ITextPdfHtmlMergeDto;
import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.biz.crm.dms.business.itextpdf.sdk.service.ITextPdfVoService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/itextpdf/iTextPdf"})
@Api(tags={"itextpdf\u76f8\u5173\u7684http"})
public class ITextPdfVoController {
    private static final Logger log = LoggerFactory.getLogger(ITextPdfVoController.class);
    @Autowired(required=false)
    private ITextPdfVoService iTextPdfVoService;

    @ApiOperation(value="\u901a\u8fc7file\u6587\u4ef6\u83b7\u53d6pdf")
    @PostMapping(value={"/createPdfByFile"})
    public Result<OrdinaryFileVo> createPdfByFile(@RequestBody ITextPdfDto iTextPdfDto) {
        try {
            MultipartFile file = iTextPdfDto.getFile();
            return Result.ok((Object)this.iTextPdfVoService.createPdfByFile(file));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7html\u83b7\u53d6pdf")
    @PostMapping(value={"/createPdfByHtml"})
    public Result<OrdinaryFileVo> createPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto) {
        try {
            String html = iTextPdfDto.getHtmlStr();
            return Result.ok((Object)this.iTextPdfVoService.createPdfByHtml(html));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="html\u8f6cpdf\uff08\u9996\u5c3ehtml\u5408\u5e76\uff09")
    @PostMapping(value={"/createPdfByHtmlMerge"})
    public Result<OrdinaryFileVo> createPdfByHtmlMerge(@RequestBody ITextPdfHtmlMergeDto dto) {
        try {
            return Result.ok((Object)this.iTextPdfVoService.createPdfByHtmlMerge(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7html\u9884\u89c8pdf")
    @PostMapping(value={"/reviewDataPdf"})
    public void reviewPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto, HttpServletResponse response) {
        try {
            String html = iTextPdfDto.getHtmlStr();
            this.iTextPdfVoService.reviewPdfByHtml(html, response);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u6587\u6863\u5e76\u8f6cpdf")
    @PostMapping(value={"/createWordToPdfFile"})
    public Result<OrdinaryFileVo> createWordDocxToPdfFile(@RequestBody WordTemplateDataVo dataVo) {
        OrdinaryFileVo ordinaryFileVo = this.iTextPdfVoService.createWordDocxToPdfFile(dataVo);
        return Result.ok((Object)ordinaryFileVo);
    }
}

