/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.itextpdf.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.biz.crm.common.itextpdf.local.model.HtmlMergePdfResultModel;
import com.biz.crm.dms.business.itextpdf.sdk.dto.ITextPdfHtmlMergeDto;
import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.biz.crm.dms.business.itextpdf.sdk.service.ITextPdfVoService;
import com.biz.crm.dms.business.itextpdf.sdk.utils.MockMultipartFile;
import com.biz.crm.dms.business.itextpdf.sdk.utils.WordSwitchPdfUtil;
import com.biz.crm.dms.business.itextpdf.sdk.utils.WordUtil;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ITextPdfVoServiceImpl
implements ITextPdfVoService {
    private static final Logger log = LoggerFactory.getLogger(ITextPdfVoServiceImpl.class);
    @Value(value="${server.port:}")
    private String subsystem;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    public OrdinaryFileVo createPdfByFile(MultipartFile html) {
        Validate.notNull((Object)html, (String)"\u8bf7\u9009\u62e9\u6587\u4ef6\uff01", (Object[])new Object[0]);
        OrdinaryFileVo uploadVo = null;
        try {
            uploadVo = this.venusFileUpload(html).get(0);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)"\u4e0a\u4f20\u9519\u8bef\u6587\u4ef6\u5931\u8d25", (Object[])new Object[0]);
        }
        return uploadVo;
    }

    private List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator(this.loginUserService.findCurrentAccount());
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString((byte[])multipartFile.getBytes())});
        List ordinaryFileVoList = this.fileHandleService.fileUpload(this.subsystem, base64UploadDto);
        Validate.notEmpty((Collection)ordinaryFileVoList, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Object[])new Object[0]);
        return ordinaryFileVoList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrdinaryFileVo createPdfByHtml(String html) {
        Validate.notNull((Object)html, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.html2Pdf(html).toByteArray());){
            MultipartFile multipartFile = MultipartFileUtil.getMultipartFile((InputStream)inputStream, (String)(System.currentTimeMillis() + ".pdf"));
            OrdinaryFileVo ordinaryFileVo = this.venusFileUpload(multipartFile).get(0);
            return ordinaryFileVo;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public OrdinaryFileVo createPdfByHtmlMerge(ITextPdfHtmlMergeDto dto) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void reviewPdfByHtml(String htmlStr, HttpServletResponse response) {
        try {
            ByteArrayOutputStream stream = this.html2Pdf(htmlStr);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
            ServletOutputStream outputStream = response.getOutputStream();
            int count = 0;
            byte[] buffer = new byte[0x100000];
            while ((count = byteArrayInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, count);
            }
            response.setContentType("application/pdf;charset=UTF-8");
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryFileVo createWordDocxToPdfFile(WordTemplateDataVo dataVo) {
        OrdinaryFileVo ordinaryFileVo = null;
        FileInputStream fileInputStream = null;
        MockMultipartFile multipartFile = null;
        try {
            String wordPath = WordUtil.createDocx((Map)dataVo.getDataMap(), (String)dataVo.getFileName(), (String)dataVo.getTemplateName(), (String)dataVo.getZipTemplateName());
            OrdinaryFileVo signFileVo = this.fileHandleService.findById(dataVo.getSignFileCode());
            byte[] bytes = this.fileHandleService.findContentByFilePathAndFileRename(signFileVo.getRelativeLocal(), signFileVo.getFileName());
            String docxSginPath = WordUtil.sealInWord((String)wordPath, (String)dataVo.getFileName(), (byte[])bytes, (String)dataVo.getTabText(), (int)dataVo.getWidth(), (int)dataVo.getHeight(), (int)dataVo.getLeftOffset(), (int)dataVo.getTopOffset(), (boolean)dataVo.getBehin());
            String docx2Pdf = WordSwitchPdfUtil.convertDocx2Pdf((String)docxSginPath, (String)dataVo.getFileName());
            File pdfFile = new File(docx2Pdf);
            fileInputStream = new FileInputStream(pdfFile);
            multipartFile = new MockMultipartFile(pdfFile.getName(), pdfFile.getName(), "application/octet-stream", (InputStream)fileInputStream);
            ordinaryFileVo = this.venusFileUpload((MultipartFile)multipartFile).get(0);
            WordUtil.deleteTemporaryFile((String)dataVo.getFileName());
        }
        catch (FileNotFoundException e) {
            Validate.isTrue((boolean)Boolean.FALSE, (String)"\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Validate.isTrue((boolean)Boolean.FALSE, (String)"IO\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    Validate.isTrue((boolean)Boolean.FALSE, (String)"IO\u5173\u95ed\u5f02\u5e38\uff01", (Object[])new Object[0]);
                }
            }
        }
        return ordinaryFileVo;
    }

    private ByteArrayOutputStream html2Pdf(String html) throws IOException {
        ConverterProperties props = new ConverterProperties();
        this.setFont(props);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PdfWriter writer = new PdfWriter((OutputStream)bao);
        PdfDocument pdf = new PdfDocument(writer);
        pdf.setDefaultPageSize(PageSize.A4);
        Document document = HtmlConverter.convertToDocument((String)html, (PdfDocument)pdf, (ConverterProperties)props);
        document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
        document.getRenderer().close();
        document.close();
        return bao;
    }

    private void setFont(ConverterProperties props) throws IOException {
        DefaultFontProvider defaultFontProvider = new DefaultFontProvider(false, false, false);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("font/SourceHanSansCN-Regular.ttf");
        byte[] bytes = MultipartFileUtil.toByteArray((InputStream)inputStream);
        PdfFont regularFont = PdfFontFactory.createFont((byte[])bytes, (String)"Identity-H", (boolean)false);
        defaultFontProvider.addFont(regularFont.getFontProgram());
        InputStream boldInputStream = this.getClass().getClassLoader().getResourceAsStream("font/SourceHanSansCN-Bold.ttf");
        byte[] boldBytes = MultipartFileUtil.toByteArray((InputStream)boldInputStream);
        PdfFont boldFont = PdfFontFactory.createFont((byte[])boldBytes, (String)"Identity-H", (boolean)false);
        defaultFontProvider.addFont(boldFont.getFontProgram());
        props.setFontProvider((FontProvider)defaultFontProvider);
    }

    /*
     * Exception decompiling
     */
    private HtmlMergePdfResultModel htmlMergeWithAppend(String headHtml, String tailHtml) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private HtmlMergePdfResultModel htmlMergeWithNewPage(String headHtml, String tailHtml) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

