package com.biz.crm.dms.business.itextpdf.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author ning.zhang
 * @description html合并生成pdf请求dto
 * @date 2023/12/5
*/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("")
public class ITextPdfHtmlMergeDto implements Serializable {

  private static final long serialVersionUID = -7446096747061462264L;

  @ApiModelProperty(value = "首部html页面")
  private String headHtml;

  @ApiModelProperty(value = "尾部html页面")
  private String tailHtml;

  @ApiModelProperty(value = "合并方式(1:追加合并, 2.新开页面合并, 3.方式1和方式2所得页数不一致时采用方式2")
  private String mergeType;
}
