package com.biz.crm.dms.business.itextpdf.sdk.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName FreeMarkUtils
 * @Author Gavin
 * @Date 2021/3/18 上午11:06
 * @Description 模板工具类
 */
@Slf4j
public class FreeMarkUtils {
    public static Configuration getConfiguration() {
        //创建配置实例
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        //设置编码
        configuration.setDefaultEncoding("utf-8");
        //模版目录
        configuration.setClassForTemplateLoading(FreeMarkUtils.class, "/templates");
        return configuration;
    }

    /**
     * 获取模板字符串输入流
     *
     * @param dataMap      参数
     * @param templateName 模板名称
     * @return
     */
    public static ByteArrayInputStream getFreemarkerContentInputStream(Map<String, Object> dataMap, String templateName) {
        ByteArrayInputStream in = null;
        try {
            //获取模板
            Template template = getConfiguration().getTemplate(templateName);
            StringWriter swriter = new StringWriter();
            //生成文件
            template.process(dataMap, swriter);

            in = new ByteArrayInputStream(swriter.toString().getBytes("utf-8"));
        } catch (Exception e) {
            Validate.isTrue(Boolean.FALSE, "模板生成错误！");
        }
        return in;
    }
}