package com.biz.crm.dms.business.itextpdf.sdk.utils;

import com.aspose.words.Document;
import com.aspose.words.License;
import com.aspose.words.SaveFormat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName WordSwitchPdfUtil
 * @Author Gavin
 * @Date 2021/3/17 下午6:21
 * @Description word转pdf
 */
@Slf4j
@Component
public class WordSwitchPdfUtil {

    private static String BASE_DIR;

    @Value("${server.tomcat.basedir:}")
    public void setBaseDir(String baseDir) {
        WordSwitchPdfUtil.BASE_DIR = baseDir;
    }

    /**
     * word（docx）转pdf
     *
     * @param wordPath
     * @return
     */
    public static String convertDocx2Pdf(String wordPath, String wordName) {
        String pdfPath = BASE_DIR + File.separator + wordName + File.separator + wordName + ".pdf";
        FileOutputStream os = null;
        if (getLicense()) {
            try {
                File file = new File(pdfPath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                os = new FileOutputStream(file);
                Document doc = new Document(wordPath);
                doc.save(os, SaveFormat.PDF);
            } catch (Exception e) {
                log.error("转换失败：{}", e.getMessage());
                return null;
            } finally {
                WordUtil.safeClose(os);
            }
        } else {
            return null;
        }
        return pdfPath;
    }


    /**
     * 获取配置文件信息
     *
     * @return boolean
     */
    public static boolean getLicense() {
        try {
            ClassPathResource classPathResource = new ClassPathResource("License.xml");
            License license = new License();
            license.setLicense(classPathResource.getInputStream());
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}