package com.biz.crm.common.log.business.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.log.business.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.business.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 业务日志
 * @author: rentao
 * @date: 2022/5/10 11:20
 */
@Slf4j
@RestController
@RequestMapping("/v1/businessLog/businessLog")
@Api(tags = "业务日志: CrmBusinessLogVo: 业务日志")
public class CrmBusinessLogEsController {

  @Autowired
  private CrmBusinessLogService crmBusinessLogService;

  @ApiOperation(value = "日志分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<CrmBusinessLogEsEntity>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable, CrmBusinessLogDto crmBusinessLogDto) {
    try {
      return Result.ok(this.crmBusinessLogService.findByConditions(pageable, crmBusinessLogDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
