package com.biz.crm.common.log.business.local.entity;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @description: 业务日志es实体
 * @author: rentao
 * @date: 2022/5/10 11:36
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@Document(indexName = "crmbusinesslog",createIndex=false)
public class CrmBusinessLogEsEntity {

  @Id
  private String id;

  @Field(type = FieldType.Keyword)
  private String operationType;

  @Field(type = FieldType.Keyword)
  private String onlyKey;

  @Field(type = FieldType.Keyword)
  private String onlyKeyDes;

  @Field(type = FieldType.Keyword)
  private String menuCode;

  @Field(type = FieldType.Text,index = false)
  private String compareResult;

  @Field(type = FieldType.Keyword)
  private String createAccount;

  @Field(type = FieldType.Keyword)
  private String createTime;

  @Field(type = FieldType.Keyword)
  private String createName;

  @Field(type = FieldType.Long)
  private Long createTimeTimeNum;
}
