package com.biz.crm.common.log.business.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.log.business.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.business.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.business.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.business.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.business.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.utils.EsUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/10 15:06
 */
@Service
@Slf4j
public class CrmBusinessLogServiceImpl implements CrmBusinessLogService {

  @Autowired
  private ElasticsearchRestTemplate elasticsearchRestTemplate;

  @Override
  public Page<CrmBusinessLogEsEntity> findByConditions(Pageable pageable,
      CrmBusinessLogDto crmBusinessLogDto) {
    Validate.notNull(crmBusinessLogDto,"查询日志参数不能为空");
    Validate.notBlank(crmBusinessLogDto.getMenuCode(),"查询日志,菜单编码不能为空");
    Validate.notBlank(crmBusinessLogDto.getOnlyKey(),"查询日志,业务id不能为空");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    if (!EsUtil.indexExsitNoCreate(this.elasticsearchRestTemplate, CrmBusinessLogEsEntity.class)) {
      return null;
    } else {
      BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
      //onlyKey + 菜单编码确定唯一
      boolQueryBuilder.must(QueryBuilders.termQuery("onlyKey.keyword", crmBusinessLogDto.getOnlyKey()));
      boolQueryBuilder.must(QueryBuilders.termQuery("menuCode.keyword", crmBusinessLogDto.getMenuCode()));
      if (null != crmBusinessLogDto.getOperationType()) {
        boolQueryBuilder.must(QueryBuilders.termQuery("operationType.keyword", crmBusinessLogDto.getOperationType()));
      }
      NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(boolQueryBuilder)
          .withSort(SortBuilders.fieldSort("operationTimeNum").unmappedType("keyword").order(SortOrder.DESC))
          .withPageable(PageRequest.of(pageable.getPageNumber() - 1, pageable.getPageSize()))
          .build();
      SearchHits<CrmBusinessLogEsEntity> searchs = this.elasticsearchRestTemplate.search(searchQuery, CrmBusinessLogEsEntity.class);
      List<CrmBusinessLogEsEntity> crmLogEntityList = searchs.get().map(SearchHit::getContent).collect(Collectors.toList());
      Page<CrmBusinessLogEsEntity> page = new Page();
      page.setTotal(searchs.getTotalHits());
      page.setRecords(crmLogEntityList);
      return page;
    }
  }

}