package com.biz.crm.common.log.business.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.log.business.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.business.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.business.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/13 20:17
 */
@Service
@Slf4j
public class CrmBusinessLogVoServiceImpl implements CrmBusinessLogVoService {

  @Autowired(required = false)
  private CrmBusinessLogEsRepository crmBusinessLogRepository;

  @Override
  @Transactional
  public void handleSave(CrmBusinessLogDto crmBusinessLogDto) {
    Validate.notNull(crmBusinessLogDto, "传入比对参数不存在！");
    Validate.notBlank(crmBusinessLogDto.getMenuCode(), "传入菜单编码不存在！");
    Validate.notBlank(crmBusinessLogDto.getOperationType(), "操作类型不能为空！");
    String operationType = crmBusinessLogDto.getOperationType();
    if (OperationTypeEunm.CREATE.getDictCode().equals(operationType)) {
      this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.vo2EntityForAdd(crmBusinessLogDto));
    } else if (OperationTypeEunm.DELETE.getDictCode().equals(operationType)) {
      this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.vo2EntityForDel(crmBusinessLogDto));
    } else {
      //对比结果
      Object resullt = LogCompare.compare(JSON.toJSONString(crmBusinessLogDto.getOldObject()), JSON.toJSONString(crmBusinessLogDto.getNewObject()));

      this.crmBusinessLogRepository.save(CrmBusinessLogUtil.vo2EntityForUpdate(crmBusinessLogDto, resullt));
    }
  }
}
