package com.biz.crm.common.log.business.local.utils;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.log.business.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;

/**
 * @description: 业务日志工具类
 * @author: rentao
 * @date: 2022/5/10 11:43
 */
public class CrmBusinessLogUtil {

  public static List<CrmBusinessLogEsEntity> vo2EntityForAdd(CrmBusinessLogDto crmBusinessLogDto) {
    List<CrmBusinessLogEsEntity> reList = null;
    Object newObject = crmBusinessLogDto.getNewObject();
    if (!(newObject instanceof Collection)) {
      reList = new ArrayList(1);
      CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
      reList.add(entity);
      return reList;
    } else {
      List<Object> newObjects = (List)newObject;
      reList = new ArrayList(newObjects.size());
      Iterator var4 = newObjects.iterator();
      while(var4.hasNext()) {
        CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
        reList.add(entity);
      }
      return reList;
    }
  }

  public static List<CrmBusinessLogEsEntity> vo2EntityForDel(CrmBusinessLogDto crmBusinessLogDto) {
    List<CrmBusinessLogEsEntity> reList = null;
    Object oldObject = crmBusinessLogDto.getOldObject();
    if (!(oldObject instanceof Collection)) {
      reList = new ArrayList(1);
      CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
      reList.add(entity);
      return reList;
    } else {
      List<Object> oldObjects = (List)oldObject;
      reList = new ArrayList(oldObjects.size());
      Iterator var4 = oldObjects.iterator();
      while(var4.hasNext()) {
        CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
        reList.add(entity);
      }
      return reList;
    }
  }

  public static CrmBusinessLogEsEntity vo2EntityForUpdate(CrmBusinessLogDto crmBusinessLogDto, Object result) {
    CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
    entity.setCompareResult(JSON.toJSONString(result));
    return entity;
  }

  public static CrmBusinessLogEsEntity newCommonFieldInstance(CrmBusinessLogDto crmBusinessLogDto) {
    CrmBusinessLogEsEntity entity = new CrmBusinessLogEsEntity();
    entity.setId(UUID.randomUUID().toString().replace("-", ""));
    entity.setOnlyKey(crmBusinessLogDto.getOnlyKey());
    entity.setOperationType(crmBusinessLogDto.getOperationType());
    entity.setMenuCode(crmBusinessLogDto.getMenuCode());
    entity.setCreateName(crmBusinessLogDto.getCreateName());
    Date date = new Date();
    String format = DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    entity.setCreateTime(format);
    entity.setCreateAccount(crmBusinessLogDto.getCreateAccount());
    entity.setCreateTimeTimeNum(date.getTime());
    return entity;
  }
}
