package com.biz.crm.common.log.business.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

/**
 * @description: 日志对比工具类
 * @author: rentao
 * @date: 2022/5/10 11:51
 */
public class LogCompare {

  /**
   * 字段对比
   * @param oldJsonStr 修改前
   * @param newJsonStr 修改后
   * @author rentao
   * @date
   */
  public static Object compare(String oldJsonStr,
      String newJsonStr) {
    return compareObjectNotBasicAndCollection(JSON.parseObject(oldJsonStr), JSON.parseObject(newJsonStr));
  }

  /**
   *
   * 对比对象合集合
   * @param oldObject
   * @param newObject
   * @author rentao
   * @date
   */
  public static JSONObject compareObjectNotBasicAndCollection(JSONObject oldObject, JSONObject newObject) {
    Validate.notNull(oldObject, "日志需要对比的字段不存在");
    Validate.notNull(newObject, "日志需要对比的字段不存在");
    JSONObject compare = OneCompare.compare(oldObject, newObject);
    //这里
    return compare;
  }

}

