package com.biz.crm.common.log.business.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * @description: 一对一对比
 * @author: rentao
 * @date: 2022/5/10 14:09
 */
public class OneCompare {

  //集合中唯一键
  private static final String ONLY_KEY = "id";

  /**
   * 字段对比
   *
   * @param oldJsonObject 修改前json
   * @param newJsonObject 修改后json
   * @author rentao
   * @date
   */
  public static JSONObject compare(JSONObject oldJsonObject, JSONObject newJsonObject) {
    JSONObject reJson = new JSONObject();
    Iterator iter = oldJsonObject.keySet().iterator();
    //循环需要对比的字段
    while (iter.hasNext()) {
      String key = (String) iter.next();
      //取出需要对比的字段
      Object oldValue = oldJsonObject.get(key);
      Object newValue = newJsonObject.get(key);
      if (oldValue instanceof JSONObject) {
        Object obj = compare((JSONObject) oldValue,
            (JSONObject) newValue);
        if (!ObjectUtils.isEmpty(obj)) {
          reJson.put(key, obj);
        }
      } else if (oldValue instanceof JSONArray) {
        List<JSONObject> obj = ManyConpare
            .compare(JSON.parseArray(JSON.toJSONString(oldValue), JSONObject.class),
                JSON.parseArray(JSON.toJSONString(newValue), JSONObject.class));
        if (!CollectionUtils.isEmpty(obj)) {
          reJson.put(key, obj);
        }
      } else {
        Object obj = BasicTypeCompare.compare(oldValue, newValue);
        if (!StringUtils.isEmpty(obj)) {
          reJson.put(key, obj);
        }
      }
    }
    return reJson;
  }
}
