/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.config;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Component
public class ShowRestUrlLoader
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ShowRestUrlLoader.class);
    @Value(value="${crm.common.show-rest-url:false}")
    private boolean showRestUrl;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (!this.showRestUrl) {
            return;
        }
        log.info("\u52a0\u8f7dRestController\u63a7\u5236\u7c7b\u6e05\u5355");
        Map beans = ctx.getBeansWithAnnotation(RestController.class);
        StringBuilder sb = new StringBuilder();
        StringBuilder urlSb = new StringBuilder();
        for (String beanName : beans.keySet()) {
            Method[] methods;
            RequestMapping requestMapping;
            String canonicalName;
            Class<?> clazz = null;
            Object value = ctx.getBean(beanName);
            if (value == null || (canonicalName = (clazz = value.getClass()).getCanonicalName()).startsWith("com.bizunited.nebula") || canonicalName.startsWith("com.biz.crm.common") || canonicalName.contains(".deprecated.") || (requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class)) == null) continue;
            String path = requestMapping.value()[0];
            Api api = (Api)AnnotationUtils.findAnnotation(clazz, Api.class);
            String description = "";
            if (api != null) {
                description = this.getFirstValue(api.tags()).replaceAll(",", "\uff0c");
            }
            urlSb.append("\n" + canonicalName + "," + path + "," + description);
            for (Method method : methods = clazz.getMethods()) {
                String url = "";
                String desc = "";
                ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
                if (apiOperation != null) {
                    desc = apiOperation.value();
                }
                RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                PostMapping postMapping = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
                GetMapping getMapping = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
                PutMapping putMapping = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
                DeleteMapping deleteMapping = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
                if (postMapping != null) {
                    url = path + this.getFirstValue(postMapping.value());
                } else if (getMapping != null) {
                    url = path + this.getFirstValue(getMapping.value());
                } else if (putMapping != null) {
                    url = path + this.getFirstValue(putMapping.value());
                } else if (deleteMapping != null) {
                    url = path + this.getFirstValue(deleteMapping.value());
                } else {
                    if (mapping == null) continue;
                    url = path + this.getFirstValue(mapping.value());
                }
                sb.append(String.format("\n%s,%s,%s", canonicalName, url, desc.replaceAll(",", "\uff0c")));
            }
        }
        log.info("URL---CSV\u683c\u5f0f===={}", (Object)urlSb);
        log.info("URL---CSV\u683c\u5f0f==== begin");
        log.info("URL---CSV\u683c\u5f0f===={}", (Object)sb);
        log.info("URL---CSV\u683c\u5f0f==== end");
    }

    private String getFirstValue(String[] value) {
        if (value.length > 0) {
            return value[0];
        }
        return "";
    }
}

