/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.local.repository.TmLogRepository;
import com.biz.crm.common.log.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.local.utils.LogTransform;
import com.biz.crm.common.log.local.vo.TmLogVo;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogQueryDto;
import com.biz.crm.common.log.sdk.strategy.CrmBusinessLogStrategy;
import com.biz.crm.common.log.sdk.utils.EsUtil;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CrmBusinessLogServiceImpl
implements CrmBusinessLogService {
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired(required=false)
    private List<CrmBusinessLogStrategy> crmBusinessLogStrategyServices;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TmLogRepository tmLogRepository;
    private static final int MAX_TOTAL = 10000;

    @Override
    public Page<CrmBusinessLogEsVo> findByConditions(Pageable pageable, CrmBusinessLogQueryDto queryDto) {
        queryDto = Optional.ofNullable(queryDto).orElse(new CrmBusinessLogQueryDto());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        if (!EsUtil.indexExsitNoCreate((ElasticsearchRestTemplate)this.elasticsearchRestTemplate, CrmBusinessLogEsEntity.class)) {
            return new Page();
        }
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        if (pageNumber > 0) {
            --pageNumber;
        }
        Assert.isTrue(((pageNumber + 1) * pageSize < 10000 ? 1 : 0) != 0, (String)"\u5206\u9875\u67e5\u8be2,\u5355\u6b21\u67e5\u8be2\u603b\u6570\u4e0d\u53ef\u8d85\u8fc7[10000]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!");
        PageRequest pageEs = PageRequest.of((int)pageNumber, (int)pageable.getPageSize());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getOnlyKey())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)queryDto.getOnlyKey()).field("onlyKey"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getAppCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)queryDto.getAppCode()).field("appCode"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getTenantCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)queryDto.getTenantCode()).field("tenantCode"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getAppName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)queryDto.getAppName()).field("appName"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getMenuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"menuName", (String)this.getLikeString(queryDto.getMenuName())));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getMenuAllName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"menuAllName", (String)this.getLikeString(queryDto.getMenuAllName())));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getOperationType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)queryDto.getOperationType()).field("operationType"));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"createTimeTimeNum").unmappedType("keyword").order(SortOrder.DESC)}).withPageable((Pageable)pageEs).build();
        SearchHits searchs = this.elasticsearchRestTemplate.search((Query)searchQuery, CrmBusinessLogEsEntity.class);
        List crmLogEntityList = searchs.get().map(SearchHit::getContent).collect(Collectors.toList());
        ArrayList<CrmBusinessLogEsVo> crmBusinessLogEsEntities = new ArrayList<CrmBusinessLogEsVo>();
        List crmBusinessLogEsVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(crmLogEntityList, CrmBusinessLogEsEntity.class, CrmBusinessLogEsVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(crmLogEntityList) && StringUtils.isNotBlank((CharSequence)queryDto.getParentCode())) {
            crmBusinessLogEsEntities.addAll(this.handleFiledTransformation(crmBusinessLogEsVoList, queryDto.getAccessType(), queryDto.getParentCode()));
        } else {
            crmBusinessLogEsEntities.addAll(crmBusinessLogEsVoList);
        }
        Page page = new Page();
        page.setTotal(searchs.getTotalHits());
        page.setRecords(crmBusinessLogEsEntities);
        page.setCurrent((long)pageable.getPageNumber());
        return page;
    }

    @Override
    public Page<TmLogVo> findByConditionsHistory(Pageable pageable, TmLogVo dto) {
        return this.tmLogRepository.findByConditionsHistory(pageable, dto);
    }

    private String getLikeString(String queryString) {
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return "";
        }
        return "*" + queryString + "*";
    }

    private List<CrmBusinessLogEsVo> handleFiledTransformation(List<CrmBusinessLogEsVo> crmBusinessLogEsVos, String accessType, String parentCode) {
        ArrayList<FieldTransformVo> list = new ArrayList<FieldTransformVo>();
        if (CollectionUtils.isEmpty(this.crmBusinessLogStrategyServices)) {
            return crmBusinessLogEsVos;
        }
        for (CrmBusinessLogStrategy crmBusinessLogStrategyService : this.crmBusinessLogStrategyServices) {
            String group = crmBusinessLogStrategyService.getTransformationCode();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)accessType)) continue;
            list.addAll(crmBusinessLogStrategyService.handleTransformation(parentCode));
            break;
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
                String s = LogTransform.fieldTransform(crmBusinessLogEsVo.getCompareResult(), list);
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                JSONObject jsonObject = JSON.parseObject((String)s);
                crmBusinessLogEsVo.setCompareResultJson(jsonObject);
            }
        }
        return crmBusinessLogEsVos;
    }
}

