/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.service.CrmBusinessLogCommonService;
import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogUtilService;
import com.bizunited.nebula.common.util.SpringBeanUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CrmBusinessLogUtilServiceImpl
implements CrmBusinessLogUtilService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessLogUtilServiceImpl.class);
    @Autowired(required=false)
    private CrmBusinessLogCommonService crmBusinessLogCommonService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public <T> void onCreate(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                this.crmBusinessLogCommonService.onCreate(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onUpdate(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        Assert.isTrue((vos.size() == 1 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u64cd\u4f5c\u65e5\u5fd7\u5355\u6b21\u53ea\u80fd\u4fdd\u5b58\u4e00\u6761\u8bb0\u5f55", (Object[])new Object[0]);
        Object original = eventDto.getOriginal();
        T newest = vos.get(0);
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        try {
            String id = this.getFieldName(newest);
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)eventDto.getOperationType())) {
                crmBusinessLogDto.setOperationType(eventDto.getOperationType());
            } else {
                crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            }
            crmBusinessLogDto.setOnlyKey(id);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setNewObject(newest);
            crmBusinessLogDto.setOldObject(original);
            crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
            crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
            crmBusinessLogDto.setMenuName(baseDto.getMenuName());
            crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
            crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
            crmBusinessLogDto.setCreateName(baseDto.getCreateName());
            this.crmBusinessLogCommonService.onUpdate(crmBusinessLogDto);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public <T> void onDisable(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DISABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                this.crmBusinessLogCommonService.onDisable(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u7981\u7528\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onEnable(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.ENABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                this.crmBusinessLogCommonService.onEnable(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u542f\u7528\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onDelete(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                this.crmBusinessLogCommonService.onDelete(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private <T> List<T> findVoListByEventDto(BusinessLogEventDto<T> eventDto) {
        ArrayList ruleVos = Lists.newArrayList();
        if (Objects.isNull(eventDto)) {
            return ruleVos;
        }
        if (Objects.nonNull(eventDto.getNewest())) {
            ruleVos.add(eventDto.getNewest());
        }
        if (CollectionUtils.isNotEmpty((Collection)eventDto.getNewestList())) {
            ruleVos.addAll(eventDto.getNewestList());
        }
        return ruleVos;
    }

    private <T> String getFieldName(T object) {
        return this.getFieldName(object, "id");
    }

    private <T> String getFieldName(T object, String fieldName) {
        try {
            Class<?> aClass = object.getClass();
            List<Field> fieldList = CrmBusinessLogUtilServiceImpl.getAllFields(aClass);
            for (Field field : fieldList) {
                if (!fieldName.equals(field.getName())) continue;
                field.setAccessible(true);
                return field.get(object).toString();
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25", (Throwable)e);
        }
        return "";
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList fieldList = Lists.newArrayList();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    private void setBusinessLogBaseInfo(CrmBusinessLogDto dto) {
        CompetenceCacheVoService competenceCacheVoService;
        CompetenceVo competenceVo;
        HttpServletRequest request;
        String menuCode;
        AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
        dto.setLoginUser(crmUserIdentity);
        dto.setCreateAccount(crmUserIdentity.getAccount());
        dto.setCreateName(crmUserIdentity.getRealName());
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && StringUtils.isNotEmpty((CharSequence)(menuCode = (request = requestAttributes.getRequest()).getHeader("MENU_CODE"))) && Objects.nonNull(competenceVo = (competenceCacheVoService = (CompetenceCacheVoService)SpringBeanUtils.getBean(CompetenceCacheVoService.class)).findCacheByCompetenceCode(menuCode))) {
            dto.setMenuCode(competenceVo.getCode());
            dto.setMenuName(competenceVo.getComment());
            dto.setMenuAllName(competenceVo.getParentCodeAllComment());
        }
    }
}

