/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.task;

import com.biz.crm.common.log.local.config.CleanCrmBusinessLogConfig;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.sdk.service.CleanBusinessLogExtendService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class DeleteCrmBusinessLogCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DeleteCrmBusinessLogCornTask.class);
    private static final String DEFAULT_CRON = "0 10 0 * * ?";
    private String cron = "0 10 0 * * ?";
    private boolean openClean;
    @Resource
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Resource
    private CleanCrmBusinessLogConfig cleanCrmBusinessLogConfig;
    @Autowired(required=false)
    private CleanBusinessLogExtendService cleanBusinessLogExtendService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    private static final String APPLICATION_NAME = "crm-mdm";

    @PostConstruct
    private void setDeleteLogCron() {
        this.setCron(this.cleanCrmBusinessLogConfig.getCleanCron());
        this.openClean = this.cleanCrmBusinessLogConfig.isOpenClean();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::deleteData, triggerContext -> {
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     \u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7:\u539f\u6765\u7684cron\uff1a[{}]]\u66f4\u65b0\u540e\u7684cron\uff1a[{}]     <=====", (Object)this.cron, (Object)cron);
        this.cron = cron;
    }

    private void deleteData() {
        String lockKey;
        block10: {
            boolean lock;
            if (!APPLICATION_NAME.equalsIgnoreCase(this.cleanCrmBusinessLogConfig.getApplicationName()) || !this.openClean) {
                return;
            }
            lockKey = "crm_business_log:del";
            if (this.redisMutexService != null && !(lock = this.redisMutexService.tryLock(lockKey, TimeUnit.MINUTES, 30))) {
                return;
            }
            if (this.cleanBusinessLogExtendService == null) {
                try {
                    Long minNum;
                    Integer saveDay = this.cleanCrmBusinessLogConfig.getSaveDay();
                    if (saveDay == null) {
                        saveDay = 90;
                    }
                    if ((minNum = this.cleanCrmBusinessLogConfig.getMinNum()) == null) {
                        minNum = 10000L;
                    }
                    log.info("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7\u6e05\u7406[{}]\u5929\u53ca\u5176\u4ee5\u524d\u7684;\u6700\u5c0f\u5b58\u653e\u6570\u91cf[{}]\u6761", (Object)saveDay, (Object)minNum);
                    long totalCount = this.elasticsearchRestTemplate.count((Query)new NativeSearchQuery((QueryBuilder)QueryBuilders.boolQuery()), CrmBusinessLogEsEntity.class);
                    if (totalCount > minNum) {
                        log.info("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7\u5f53\u524d\u603b[{}]\u6761,\u5927\u4e8e\u65e5\u5fd7\u4fdd\u6709\u6700\u5c0f\u91cf[{}],\u5f00\u59cb\u6e05\u7406\u65e5\u5fd7\u3002", (Object)totalCount, (Object)minNum);
                        long saveDayMillis = 86400000L * (long)saveDay.intValue();
                        long cleanMillis = System.currentTimeMillis() - saveDayMillis;
                        SimpleDateFormat dateYyyyMMDdHHMmSs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String cleanDate = dateYyyyMMDdHHMmSs.format(new Date(cleanMillis));
                        log.info("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7\u6e05\u7406[{}][{}]\u53ca\u5176\u4ee5\u524d\u7684", (Object)cleanDate, (Object)cleanMillis);
                        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createTimeTimeNum").lte((Object)cleanMillis));
                        NativeSearchQuery deleteQuery = new NativeSearchQuery((QueryBuilder)boolQueryBuilder);
                        ByQueryResponse queryResponse = this.elasticsearchRestTemplate.delete((Query)deleteQuery, CrmBusinessLogEsEntity.class);
                        log.info("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7\u6e05\u7406\u6570\u91cf:[{}]\u6761", (Object)queryResponse.getDeleted());
                        break block10;
                    }
                    log.info("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7\u5f53\u524d\u603b[{}]\u6761,\u5c0f\u4e8e\u65e5\u5fd7\u4fdd\u6709\u6700\u5c0f\u91cf[{}],\u4e0d\u6e05\u7406\u65e5\u5fd7\u3002", (Object)totalCount, (Object)minNum);
                }
                catch (Exception e) {
                    log.error("\u6e05\u7406\u4e1a\u52a1\u64cd\u4f5cES\u65e5\u5fd7 \u5f02\u5e38");
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                this.cleanBusinessLogExtendService.cleanBusinessLog();
            }
        }
        if (this.redisMutexService != null) {
            this.redisMutexService.unlock(lockKey);
        }
    }
}

