package com.biz.crm.common.log.local.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 业务操作日志清理
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024.03.01 18:01
 */
@Configuration
@Data
public class CleanCrmBusinessLogConfig {

    /**
     * 应用名称
     */
    @Value("${spring.application.name:}")
    private String applicationName;

    /**
     * 定时任务是否清理业务日志
     */
    @Value("${crm-business-log.open-clean:false}")
    private boolean openClean;

    /**
     * 定时任务清理日志时间
     */
    @Value("${crm-business-log.clean-cron:0 10 0 * * ?}")
    private String cleanCron;

    /**
     * 日志保留天数
     */
    @Value("${crm-business-log.save-day:90}")
    private Integer saveDay;

    /**
     * 日志最小保有量
     */
    @Value("${crm-business-log.min-num:10000}")
    private Long minNum;

}
