package com.biz.crm.common.log.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 1.0业务日志
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2025/2/20 16:55
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "tm_log", indexes = {
        @Index(name = "tm_log_index1", columnList = "business_id", unique = false),
        @Index(name = "tm_log_index2", columnList = "business_desc", unique = false),
        @Index(name = "tm_log_index3", columnList = "create_date", unique = false),
        @Index(name = "tm_log_index4", columnList = "operation_type", unique = false),
})
@TableName(value = "tm_log")
@org.hibernate.annotations.Table(appliesTo = "tm_log", comment = "日志信息表")
public class TmLogEntity extends UuidEntity {

    private static final long serialVersionUID = -4420142440421286222L;

    @ApiModelProperty("业务ID")
    @TableField(value = "business_id")
    @Column(name = "business_id")
    private String businessId;

    @ApiModelProperty("业务描述")
    @TableField(value = "business_desc")
    @Column(name = "business_desc")
    private String businessDesc;

    @ApiModelProperty("日志类型")
    @TableField(value = "operation_type")
    @Column(name = "operation_type")
    private String operationType;

    @ApiModelProperty("日志内容")
    @TableField(value = "content")
    @Column(name = "content")
    private String content;

    @ApiModelProperty("职位名称")
    @TableField(value = "position_name")
    @Column(name = "position_name")
    private String positionName;

    @ApiModelProperty("创建时间")
    @TableField(value = "create_date", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "create_date", length = 20, columnDefinition = "DATE")
    private Date createDate;

    @ApiModelProperty("创建人")
    @TableField(value = "create_name", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_name", columnDefinition = "VARCHAR2(128)")
    private String createName;


}
